<div>
    <form wire:submit="save">
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="percentage" class="form-label">Annual Pass Percentage (%)</label>
                    <input type="number" 
                           wire:model="percentage" 
                           class="form-control @error('percentage') is-invalid @enderror" 
                           id="percentage" 
                           min="0" 
                           max="100" 
                           step="0.01"
                           placeholder="Enter pass percentage">
                    @error('percentage')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <div class="form-text">
                        Students with annual average equal to or above this percentage will pass.
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-12">
                <button type="submit" class="btn btn-primary me-2">
                    <i class="fas fa-save"></i> Save Settings
                </button>
                <a href="{{ route('dashboard') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Dashboard
                </a>
            </div>
        </div>
    </form>
</div>