<div>
    <!-- Tab Navigation -->
    <ul class="nav nav-tabs d-none d-md-flex mb-4" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link {{ $currentTab === 'basic' ? 'active text-primary' : 'text-muted' }}"
                    wire:click="switchTab('basic')" type="button">
                <i class="fas fa-user me-2"></i>Basic Information
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link {{ $currentTab === 'contact' ? 'active text-primary' : 'text-muted' }}"
                    wire:click="switchTab('contact')" type="button"
                    {{ !$staffId ? 'disabled' : '' }}>
                <i class="fas fa-address-card me-2"></i>Contact Details
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link {{ $currentTab === 'nok' ? 'active text-primary' : 'text-muted' }}"
                    wire:click="switchTab('nok')" type="button"
                    {{ !$staffId ? 'disabled' : '' }}>
                <i class="fas fa-users me-2"></i>Next of Kin
            </button>
        </li>
        @if($staffId)
            <li class="nav-item" role="presentation">
                <button class="nav-link {{ $currentTab === 'security' ? 'active text-primary' : 'text-muted' }}"
                        wire:click="switchTab('security')" type="button">
                    <i class="fas fa-shield-alt me-2"></i>Security
                </button>
            </li>
        @endif
    </ul>

    <!-- Mobile Tab Navigation -->
    <div class="d-md-none mb-4">
        <div class="row g-2">
            <div class="col-6">
                <button class="btn {{ $currentTab === 'basic' ? 'btn-primary' : 'btn-outline-primary' }} w-100"
                        wire:click="switchTab('basic')" type="button">
                    <i class="fas fa-user d-block mb-1"></i>
                    <small>Basic Info</small>
                </button>
            </div>
            <div class="col-6">
                <button class="btn {{ $currentTab === 'contact' ? 'btn-primary' : 'btn-outline-primary' }} w-100"
                        wire:click="switchTab('contact')" type="button"
                        {{ !$staffId ? 'disabled' : '' }}>
                    <i class="fas fa-address-card d-block mb-1"></i>
                    <small>Contact</small>
                </button>
            </div>
            <div class="col-6">
                <button class="btn {{ $currentTab === 'nok' ? 'btn-primary' : 'btn-outline-primary' }} w-100"
                        wire:click="switchTab('nok')" type="button"
                        {{ !$staffId ? 'disabled' : '' }}>
                    <i class="fas fa-users d-block mb-1"></i>
                    <small>Next of Kin</small>
                </button>
            </div>
            @if($staffId)
                <div class="col-6">
                    <button class="btn {{ $currentTab === 'security' ? 'btn-primary' : 'btn-outline-primary' }} w-100"
                            wire:click="switchTab('security')" type="button">
                        <i class="fas fa-shield-alt d-block mb-1"></i>
                        <small>Security</small>
                    </button>
                </div>
            @endif
        </div>
    </div>

    <!-- Basic Information Tab -->
    @if($currentTab === 'basic')
        <form wire:submit.prevent="saveBasic">
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="firstname" class="form-label">First Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('firstname') is-invalid @enderror" 
                           wire:model="firstname" id="firstname">
                    @error('firstname') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                
                <div class="col-md-4 mb-3">
                    <label for="middlename" class="form-label">Middle Name</label>
                    <input type="text" class="form-control @error('middlename') is-invalid @enderror" 
                           wire:model="middlename" id="middlename">
                    @error('middlename') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                
                <div class="col-md-4 mb-3">
                    <label for="surname" class="form-label">Surname <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('surname') is-invalid @enderror" 
                           wire:model="surname" id="surname">
                    @error('surname') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
            </div>

@can('admin')
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                           wire:model="email" id="email">
                    @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                
                @if(!$staffId)
                    <div class="col-md-6 mb-3">
                        <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
                        <input type="password" class="form-control @error('password') is-invalid @enderror" 
                               wire:model="password" id="password">
                        @error('password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                @endif
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="role_id" class="form-label">Role <span class="text-danger">*</span></label>
                    <select class="form-select @error('role_id') is-invalid @enderror" wire:model="role_id" id="role_id">
                        <option value="">Select Role</option>
                        @foreach($roles as $role)
                            <option value="{{ $role->id }}">{{ $role->display_name }}</option>
                        @endforeach
                    </select>
                    @error('role_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                
                <div class="col-md-6 mb-3">
                    <label for="gender" class="form-label">Gender <span class="text-danger">*</span></label>
                    <select class="form-select @error('gender') is-invalid @enderror" wire:model="gender" id="gender">
                        <option value="">Select Gender</option>
                        <option value="male">Male</option>
                        <option value="female">Female</option>
                    </select>
                    @error('gender') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="marital_status" class="form-label">Marital Status <span class="text-danger">*</span></label>
                    <select class="form-select @error('marital_status') is-invalid @enderror" wire:model="marital_status" id="marital_status">
                        <option value="">Select Marital Status</option>
                        <option value="single">Single</option>
                        <option value="married">Married</option>
                        <option value="divorced">Divorced</option>
                        <option value="widowed">Widowed</option>
                        <option value="other">Other</option>
                    </select>
                    @error('marital_status') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
            </div>
@else
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                           wire:model="email" id="email">
                    @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                
                <div class="col-md-6 mb-3">
                    <label for="gender" class="form-label">Gender <span class="text-danger">*</span></label>
                    <select class="form-select @error('gender') is-invalid @enderror" wire:model="gender" id="gender">
                        <option value="">Select Gender</option>
                        <option value="male">Male</option>
                        <option value="female">Female</option>
                    </select>
                    @error('gender') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="marital_status" class="form-label">Marital Status <span class="text-danger">*</span></label>
                    <select class="form-select @error('marital_status') is-invalid @enderror" wire:model="marital_status" id="marital_status">
                        <option value="">Select Marital Status</option>
                        <option value="single">Single</option>
                        <option value="married">Married</option>
                        <option value="divorced">Divorced</option>
                        <option value="widowed">Widowed</option>
                        <option value="other">Other</option>
                    </select>
                    @error('marital_status') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
            </div>
            
            @if(!$staffId)
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
                    <input type="password" class="form-control @error('password') is-invalid @enderror" 
                           wire:model="password" id="password">
                    @error('password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
            </div>
            @endif
@endcan

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="dob" class="form-label">Date of Birth <span class="text-danger">*</span></label>
                    <input type="date" class="form-control @error('dob') is-invalid @enderror" 
                           wire:model="dob" id="dob">
                    @error('dob') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                
                <div class="col-md-6 mb-3">
                    <label for="phone" class="form-label">Phone <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                           wire:model="phone" id="phone">
                    @error('phone') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
            </div>

            <div class="mb-3">
                <label for="profile_photo" class="form-label">Passport Photograph</label>
                <input type="file" class="form-control @error('profile_photo') is-invalid @enderror" 
                       wire:model="profile_photo" id="profile_photo" accept="image/*">
                @error('profile_photo') <div class="invalid-feedback">{{ $message }}</div> @enderror
                @if($profile_photo)
                    <div class="mt-2">
                        @if(is_object($profile_photo) && method_exists($profile_photo, 'temporaryUrl'))
                            <img src="{{ $profile_photo->temporaryUrl() }}" alt="Preview" 
                                 class="img-thumbnail" style="width: 100px; height: 100px; object-fit: cover;">
                        @elseif(is_string($profile_photo))
                            <img src="{{ asset('storage/' . $profile_photo) }}" alt="Current Photo" 
                                 class="img-thumbnail" style="width: 100px; height: 100px; object-fit: cover;">
                        @endif
                    </div>
                @endif
            </div>

            <div class="d-flex justify-content-start">
                <button type="submit" class="btn btn-primary me-2">
                    <i class="fas fa-arrow-right me-2"></i>{{ $staffId ? 'Update & Continue' : 'Save & Continue' }}
                </button>
                <a href="{{ route('staff.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancel
                </a>
            </div>
        </form>
    @endif

    <!-- Contact Details Tab -->
    @if($currentTab === 'contact')
        <form wire:submit.prevent="saveContact">
            <div class="mb-3">
                <label for="address" class="form-label">Address</label>
                <textarea class="form-control @error('address') is-invalid @enderror" 
                          wire:model="address" id="address" rows="3" 
                          placeholder="Enter full address"></textarea>
                @error('address') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="country_id" class="form-label">Country</label>
                    <div class="input-group">
                        <select class="form-select @error('country_id') is-invalid @enderror" 
                                wire:model="country_id" wire:change="loadStates" wire:click="loadCountries" id="country_id">
                            <option value="">Select Country</option>
                            @foreach($countries as $country)
                                <option value="{{ $country->id }}">{{ $country->name }}</option>
                            @endforeach
                        </select>
                        @if($loadingCountries)
                            <span class="input-group-text">
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                        @endif
                    </div>
                    @error('country_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                
                <div class="col-md-4 mb-3">
                    <label for="state_id" class="form-label">State</label>
                    <div class="input-group">
                        <select class="form-select @error('state_id') is-invalid @enderror" 
                                wire:model="state_id" wire:change="loadCities" id="state_id" {{ !$country_id ? 'disabled' : '' }}>
                            <option value="">Select State</option>
                            @foreach($states as $state)
                                <option value="{{ $state->id }}">{{ $state->name }}</option>
                            @endforeach
                        </select>
                        @if($loadingStates)
                            <span class="input-group-text">
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                        @endif
                    </div>
                    @error('state_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                
                <div class="col-md-4 mb-3">
                    <label for="city_id" class="form-label">City</label>
                    <div class="input-group">
                        <select class="form-select @error('city_id') is-invalid @enderror" 
                                wire:model="city_id" id="city_id" {{ !$state_id ? 'disabled' : '' }}>
                            <option value="">Select City</option>
                            @foreach($cities as $city)
                                <option value="{{ $city->id }}">{{ $city->name }}</option>
                            @endforeach
                        </select>
                        @if($loadingCities)
                            <span class="input-group-text">
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                        @endif
                    </div>
                    @error('city_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
            </div>

            <div class="d-flex justify-content-start">
                <button type="submit" class="btn btn-primary me-2">
                    <i class="fas fa-arrow-right me-2"></i>Save & Continue
                </button>
                <button type="button" class="btn btn-secondary me-2" wire:click="switchTab('basic')">
                    <i class="fas fa-arrow-left me-2"></i>Previous
                </button>
                <a href="{{ route('staff.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-times me-2"></i>Cancel
                </a>
            </div>
        </form>
    @endif

    <!-- Next of Kin Tab -->
    @if($currentTab === 'nok')
        <form wire:submit.prevent="saveNok">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="nok_name" class="form-label">Next of Kin Name</label>
                    <input type="text" class="form-control @error('nok_name') is-invalid @enderror" 
                           wire:model="nok_name" id="nok_name">
                    @error('nok_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                
                <div class="col-md-6 mb-3">
                    <label for="nok_phone" class="form-label">Next of Kin Phone</label>
                    <input type="text" class="form-control @error('nok_phone') is-invalid @enderror" 
                           wire:model="nok_phone" id="nok_phone">
                    @error('nok_phone') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="nok_relationship" class="form-label">Relationship</label>
                    <input type="text" class="form-control @error('nok_relationship') is-invalid @enderror" 
                           wire:model="nok_relationship" id="nok_relationship" 
                           placeholder="e.g., Spouse, Parent, Sibling">
                    @error('nok_relationship') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
            </div>

            <div class="mb-3">
                <label for="nok_address" class="form-label">Next of Kin Address</label>
                <textarea class="form-control @error('nok_address') is-invalid @enderror" 
                          wire:model="nok_address" id="nok_address" rows="3"></textarea>
                @error('nok_address') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="d-flex justify-content-start">
                <button type="submit" class="btn btn-success me-2">
                    <i class="fas fa-check me-2"></i>Complete Registration
                </button>
                <button type="button" class="btn btn-secondary me-2" wire:click="switchTab('contact')">
                    <i class="fas fa-arrow-left me-2"></i>Previous
                </button>
                <a href="{{ route('staff.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-times me-2"></i>Cancel
                </a>
            </div>
        </form>
    @endif

    <!-- Security Tab -->
    @if($currentTab === 'security' && $staffId)
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Set Custom Password</h5>
                    </div>
                    <div class="card-body">
                        <form wire:submit.prevent="setCustomPassword">
                            <div class="mb-3">
                                <label for="new_password" class="form-label">New Password</label>
                                <input type="password" class="form-control @error('new_password') is-invalid @enderror" 
                                       wire:model="new_password" id="new_password">
                                @error('new_password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            
                            <div class="mb-3">
                                <label for="confirm_password" class="form-label">Confirm Password</label>
                                <input type="password" class="form-control @error('confirm_password') is-invalid @enderror" 
                                       wire:model="confirm_password" id="confirm_password">
                                @error('confirm_password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-key me-2"></i>Set Password
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Account Status</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <span class="badge {{ $active ? 'bg-success' : 'bg-danger' }} fs-6">
                                {{ $active ? 'Active' : 'Blocked' }}
                            </span>
                        </div>
                        
                        <button type="button" class="btn {{ $active ? 'btn-danger' : 'btn-success' }}" 
                                wire:click="toggleStaffStatus">
                            <i class="fas {{ $active ? 'fa-ban' : 'fa-check' }} me-2"></i>
                            {{ $active ? 'Block Access' : 'Activate Access' }}
                        </button>
                    </div>
                </div>
                
                @can('admin')
                <div class="card mt-3">
                    <div class="card-header bg-danger text-white">
                        <h5 class="card-title mb-0 text-light">Danger Zone</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted">Once you delete this staff member, there is no going back. Please be certain.</p>
                        <button type="button" class="btn btn-danger" 
                                onclick="confirmDelete('{{ $staffId }}', '{{ $firstname }} {{ $surname }}')">
                            <i class="fas fa-trash me-2"></i>Delete Staff
                        </button>
                    </div>
                </div>
                @endcan
            </div>
        </div>
    @endif
</div>

@push('scripts')
<script>
function confirmDelete(staffId, staffName) {
    Swal.fire({
        title: 'Delete Staff Member?',
        text: `Are you sure you want to delete ${staffName}? This action cannot be undone.`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: 'var(--bs-primary)',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, Delete',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            @this.call('deleteStaff');
        }
    });
}
</script>
@endpush