<div>
    <div class="row g-3">
        <div class="col-lg-6 col-12">
            <div class="card">
                <div class="card-header">
                    <h5>Staff List</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <input type="text" wire:model.live="search" class="form-control" placeholder="Search staff...">
                    </div>

                    <!-- Mobile: Accordion view -->
                    <div class="d-lg-none">
                        @foreach($staff as $member)
                            <div class="card mb-2">
                                <div class="card-body p-3">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">{{ $member->name }}</h6>
                                            <div class="mb-2">
                                                @foreach($member->roles as $role)
                                                    <span
                                                        class="badge bg-secondary me-1">{{ ucfirst($role->display_name) }}</span>
                                                @endforeach
                                            </div>
                                            <p class="mb-0 text-muted">
                                                ₦{{ number_format($member->monthly_salary ?? 0, 0) }}</p>
                                        </div>
                                        <button wire:click="selectStaff({{ $member->id }})"
                                                class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Desktop: Table view -->
                    <div class="d-none d-lg-block">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Role</th>
                                    <th>Salary</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($staff as $member)
                                    <tr>
                                        <td>{{ $member->name }}</td>
                                        <td>
                                            @foreach($member->roles as $role)
                                                <span
                                                    class="badge bg-secondary">{{ ucfirst($role->display_name) }}</span>
                                            @endforeach
                                        </td>
                                        <td>₦{{ number_format($member->monthly_salary ?? 0, 0) }}</td>
                                        <td>
                                            <button wire:click="selectStaff({{ $member->id }})"
                                                    class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit me-2"></i>Edit
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    {{ $staff->links('custom.pagination') }}
                </div>
            </div>
        </div>

        <div class="col-lg-6 col-12">
            @if($selectedStaff)
                <div class="card">
                    <div class="card-header">
                        <h5>Edit Salary - {{ $selectedStaff->name }}</h5>
                    </div>
                    <div class="card-body">
                        <form wire:submit="updateSalary">
                            <div class="row g-2">
                                <div class="col-12">
                                    <label class="form-label">Monthly Salary *</label>
                                    <input type="number" wire:model="monthly_salary" class="form-control" step="1"
                                           required>
                                    @error('monthly_salary')
                                    <div class="text-danger">{{ $message }}</div> @enderror
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Bank Name</label>
                                    <input type="text" wire:model="bank_name" class="form-control">
                                    @error('bank_name')
                                    <div class="text-danger">{{ $message }}</div> @enderror
                                </div>

                                <div class="col-sm-6">
                                    <label class="form-label">Account Number</label>
                                    <input type="text" wire:model="account_number" class="form-control">
                                    @error('account_number')
                                    <div class="text-danger">{{ $message }}</div> @enderror
                                </div>

                                <div class="col-sm-6">
                                    <label class="form-label">Account Name</label>
                                    <input type="text" wire:model="account_name" class="form-control">
                                    @error('account_name')
                                    <div class="text-danger">{{ $message }}</div> @enderror
                                </div>

                                <div class="col-sm-6">
                                    <label class="form-label">Tax ID</label>
                                    <input type="text" wire:model="tax_id" class="form-control">
                                    @error('tax_id')
                                    <div class="text-danger">{{ $message }}</div> @enderror
                                </div>

                                <div class="col-sm-6">
                                    <label class="form-label">Payment Day *</label>
                                    <input type="number" wire:model="payment_day" class="form-control" min="1" max="31"
                                           required>
                                    @error('payment_day')
                                    <div class="text-danger">{{ $message }}</div> @enderror
                                </div>

                                <div class="col-12 mt-3">
                                    <button type="submit" class="btn btn-primary w-100">
                                        <i class="fas fa-save me-2"></i>Update Salary
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            @else
                <div class="card">
                    <div class="card-body text-center">
                        <i class="fas fa-user-plus fa-3x text-muted mb-3"></i>
                        <p class="text-muted">Select a staff member to edit their salary information</p>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
