<div>
    <!-- Search and Pagination Row (Medium+ screens) -->
    <div class="row mb-2 d-none d-md-flex">
        <div class="col-md-8">
            <input type="text" class="form-control" placeholder="Search staff..." wire:model.live="search">
        </div>
        <div class="col-md-4">
            <select class="form-select" wire:model.live="perPage">
                <option value="10">10 per page</option>
                <option value="25">25 per page</option>
                <option value="50">50 per page</option>
            </select>
        </div>
    </div>
    
    <!-- Search Row (Mobile only) -->
    <div class="row mb-2 d-md-none">
        <div class="col-12">
            <input type="text" class="form-control" placeholder="Search staff..." wire:model.live="search">
        </div>
    </div>
    
    <!-- Filters Row -->
    <div class="row mb-3">
        <div class="col-lg-6 col-md-6 col-sm-6 mb-2">
            <select class="form-select" wire:model.live="roleFilter">
                <option value="">All Roles</option>
                @foreach($roles as $role)
                    <option value="{{ $role->name }}">{{ $role->display_name }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 mb-2">
            <select class="form-select" wire:model.live="statusFilter">
                <option value="">All Status</option>
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
            </select>
        </div>
        <!-- Pagination dropdown for mobile only -->
        <div class="col-12 d-md-none mb-2">
            <select class="form-select" wire:model.live="perPage">
                <option value="10">10 per page</option>
                <option value="25">25 per page</option>
                <option value="50">50 per page</option>
            </select>
        </div>
    </div>

    <!-- Staff Accordions -->
    <div>
        @forelse($staff as $index => $member)
            <div class="card mb-2">
                <div class="card-header p-0">
                    <div class="d-flex">
                        <div class="flex-grow-1 p-3" data-bs-toggle="collapse" data-bs-target="#staff{{ $member->id }}" style="cursor: pointer;">
                            <div class="d-flex justify-content-between align-items-center">
                                <!-- Desktop and Medium screen view -->
                                <div class="d-none d-md-block">
                                    <span class="badge bg-light text-dark me-2">{{ $staff->firstItem() + $index }}</span>
                                    <strong>{{ $member->name }}</strong>
                                    @if($member->roles->count())
                                        <span class="badge bg-primary ms-2">{{ $member->roles->first()->display_name }}</span>
                                    @else
                                        <span class="badge bg-secondary ms-2">No Role</span>
                                    @endif
                                </div>
                                
                                <!-- Mobile view - show only name and number -->
                                <div class="d-md-none">
                                    <span class="badge bg-light text-dark me-2">{{ $staff->firstItem() + $index }}</span>
                                    <strong>{{ $member->name }}</strong>
                                </div>
                                
                                <!-- Desktop status badges -->
                                <div class="d-none d-md-block">
                                    @if($member->active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </div>
                                
                                <!-- Mobile chevron -->
                                <div class="d-md-none">
                                    <i class="fas fa-chevron-down text-muted"></i>
                                </div>
                            </div>
                        </div>
                        @if($member->username)
                            <div class="p-3 border-start">
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary" type="button" data-bs-toggle="dropdown">
                                        <i class="fas fa-bars"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-sm">
                                        <li><a class="dropdown-item dropdown-item-sm" href="{{ route('staff.show', $member->username) }}">
                                            <i class="fas fa-eye me-2"></i>View Profile
                                        </a></li>
                                        <li><a class="dropdown-item dropdown-item-sm" href="{{ route('staff.edit', $member->username) }}">
                                            <i class="fas fa-edit me-2"></i>Edit
                                        </a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><button class="dropdown-item dropdown-item-sm text-warning" onclick="confirmDeactivate('{{ $member->id }}', '{{ $member->name }}')">
                                            <i class="fas fa-ban me-2"></i>{{ $member->active ? 'Deactivate' : 'Activate' }}
                                        </button></li>
                                    </ul>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="collapse" id="staff{{ $member->id }}">
                    <div class="card-body">
                        <!-- Mobile status info -->
                        <div class="d-md-none mb-3">
                            <div class="d-flex flex-wrap gap-2 mb-2">
                                @if($member->roles->count())
                                    <span class="badge bg-primary">{{ $member->roles->first()->display_name }}</span>
                                @else
                                    <span class="badge bg-secondary">No Role</span>
                                @endif
                                @if($member->active)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-danger">Inactive</span>
                                @endif
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-3 text-center mb-3">
                                @if($member->profile_photo)
                                    <img src="{{ asset('storage/' . $member->profile_photo) }}" alt="{{ $member->name }}" 
                                         class="img-thumbnail rounded" style="width: 120px; height: 120px; object-fit: cover;" loading="lazy">
                                @else
                                    <div class="bg-light border rounded d-inline-flex align-items-center justify-content-center" 
                                         style="width: 120px; height: 120px;">
                                        <i class="fas fa-user text-muted" style="font-size: 45px;"></i>
                                    </div>
                                @endif
                            </div>
                            <div class="col-md-4">
                                <p><strong>Username:</strong> <code>{{ $member->username }}</code></p>
                                <p><strong>Email:</strong> {{ $member->email }}</p>
                                <p><strong>Phone:</strong> {{ $member->phone ?: 'N/A' }}</p>
                            </div>
                            <div class="col-md-5">
                                @if($member->classes->count())
                                    <p><strong>Assigned Classes:</strong></p>
                                    <div>
                                        @foreach($member->classes as $class)
                                            <span class="badge bg-info me-1 mb-1">{{ $class->display_name }}</span>
                                        @endforeach
                                    </div>
                                @else
                                    <p><strong>Assigned Classes:</strong> <span class="text-muted">None</span></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="text-center py-4">
                <p>No staff found</p>
            </div>
        @endforelse
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-center">
        {{ $staff->links('custom.pagination') }}
    </div>
</div>

<script>
function confirmDeactivate(staffId, staffName) {
    Swal.fire({
        title: 'Toggle Staff Status?',
        text: `Are you sure you want to change ${staffName}'s access status?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: 'var(--primary-color)',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, Change Status',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            @this.deactivateStaff(staffId);
        }
    });
}
</script>