<div>
    <!-- Tab Navigation -->
    <ul class="nav nav-tabs d-none d-md-flex mb-4" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link {{ $currentTab === 'basic' ? 'active text-primary' : 'text-muted' }}"
                    wire:click="switchTab('basic')" type="button">
                <i class="fas fa-user me-2"></i>Basic Info
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link {{ $currentTab === 'personal' ? 'active text-primary' : 'text-muted' }}"
                    wire:click="switchTab('personal')" type="button"
                {{ !$studentId ? 'disabled' : '' }}>
                <i class="fas fa-id-card me-2"></i>Personal
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link {{ $currentTab === 'academic' ? 'active text-primary' : 'text-muted' }}"
                    wire:click="switchTab('academic')" type="button"
                {{ !$studentId ? 'disabled' : '' }}>
                <i class="fas fa-graduation-cap me-2"></i>Academic
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link {{ $currentTab === 'guardian' ? 'active text-primary' : 'text-muted' }}"
                    wire:click="switchTab('guardian')" type="button"
                {{ !$studentId ? 'disabled' : '' }}>
                <i class="fas fa-users me-2"></i>Guardian
            </button>
        </li>
        @if($studentId)
            <li class="nav-item" role="presentation">
                <button class="nav-link {{ $currentTab === 'security' ? 'active text-primary' : 'text-muted' }}"
                        wire:click="switchTab('security')" type="button">
                    <i class="fas fa-shield-alt me-2"></i>Security
                </button>
            </li>
        @endif
    </ul>

    <!-- Mobile Tab Navigation -->
    <div class="d-md-none mb-4">
        <div class="row g-2">
            <div class="col-6">
                <button class="btn {{ $currentTab === 'basic' ? 'btn-primary' : 'btn-outline-primary' }} w-100"
                        wire:click="switchTab('basic')" type="button">
                    <i class="fas fa-user d-block mb-1"></i>
                    <small>Basic Info</small>
                </button>
            </div>
            <div class="col-6">
                <button class="btn {{ $currentTab === 'personal' ? 'btn-primary' : 'btn-outline-primary' }} w-100"
                        wire:click="switchTab('personal')" type="button"
                    {{ !$studentId ? 'disabled' : '' }}>
                    <i class="fas fa-id-card d-block mb-1"></i>
                    <small>Personal</small>
                </button>
            </div>
            <div class="col-6">
                <button class="btn {{ $currentTab === 'academic' ? 'btn-primary' : 'btn-outline-primary' }} w-100"
                        wire:click="switchTab('academic')" type="button"
                    {{ !$studentId ? 'disabled' : '' }}>
                    <i class="fas fa-graduation-cap d-block mb-1"></i>
                    <small>Academic</small>
                </button>
            </div>
            <div class="col-6">
                <button class="btn {{ $currentTab === 'guardian' ? 'btn-primary' : 'btn-outline-primary' }} w-100"
                        wire:click="switchTab('guardian')" type="button"
                    {{ !$studentId ? 'disabled' : '' }}>
                    <i class="fas fa-users d-block mb-1"></i>
                    <small>Guardian</small>
                </button>
            </div>
            @if($studentId)
                <div class="col-6">
                    <button class="btn {{ $currentTab === 'security' ? 'btn-primary' : 'btn-outline-primary' }} w-100"
                            wire:click="switchTab('security')" type="button">
                        <i class="fas fa-shield-alt d-block mb-1"></i>
                        <small>Security</small>
                    </button>
                </div>
            @endif
        </div>
    </div>

    <!-- Tab Content -->
    <div class="tab-content">
        <!-- Basic Information Tab -->
        @if($currentTab === 'basic')
            <form wire:submit.prevent="saveBasic">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="firstname" class="form-label">First Name <span class="text-danger">*</span></label>
                        <input type="text" wire:model="firstname"
                               class="form-control @error('firstname') is-invalid @enderror" id="firstname">
                        @error('firstname')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="surname" class="form-label">Surname <span class="text-danger">*</span></label>
                        <input type="text" wire:model="surname"
                               class="form-control @error('surname') is-invalid @enderror" id="surname">
                        @error('surname')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="middlename" class="form-label">Middle Name</label>
                        <input type="text" wire:model="middlename"
                               class="form-control @error('middlename') is-invalid @enderror" id="middlename">
                        @error('middlename')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="email" class="form-label">Email
                            @if($studentId)
                                <input type="checkbox" wire:model.live="enable_email_edit" class="form-check-input ms-2"
                                       id="enable_email">
                                <label for="enable_email" class="form-check-label ms-1 small">Enable Edit</label>
                            @endif
                        </label>
                        <input type="email" wire:model="email" class="form-control @error('email') is-invalid @enderror"
                               id="email"
                               placeholder="Leave blank to auto-generate" {{ $studentId && !$enable_email_edit ? 'disabled' : '' }}>
                        @error('email')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="student_id" class="form-label">Student ID
                            @if($studentId)
                                <input type="checkbox" wire:model.live="enable_student_id_edit"
                                       class="form-check-input ms-2" id="enable_student_id">
                                <label for="enable_student_id" class="form-check-label ms-1 small">Enable Edit</label>
                            @endif
                        </label>
                        <input type="text" wire:model="student_id"
                               class="form-control @error('student_id') is-invalid @enderror" id="student_id"
                               placeholder="Leave blank to auto-generate"
                               maxlength="10" {{ $studentId && !$enable_student_id_edit ? 'disabled' : '' }}>
                        @error('student_id')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    @if(!$studentId)
                        <div class="col-md-6 mb-3">
                            <label for="school_class_id" class="form-label">Class <span class="text-danger">*</span></label>
                            <select wire:model.live="school_class_id" class="form-select @error('school_class_id') is-invalid @enderror"
                                    id="school_class_id">
                                <option value="">Select Class</option>
                                @foreach($schoolClasses as $class)
                                    <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                                @endforeach
                            </select>
                            @error('school_class_id')
                            <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="batch_id" class="form-label">Batch <span class="text-danger">*</span></label>
                            <select wire:model="batch_id" class="form-select @error('batch_id') is-invalid @enderror"
                                    id="batch_id" {{ !$school_class_id ? 'disabled' : '' }}>
                                <option value="">{{ $school_class_id ? 'Select Batch' : 'Select Class First' }}</option>
                                @foreach($batches as $batch)
                                    <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                                @endforeach
                            </select>
                            @error('batch_id')
                            <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    @endif

                    <div class="col-md-6 mb-3">
                        <label for="gender" class="form-label">Gender <span class="text-danger">*</span></label>
                        <select wire:model="gender" class="form-select @error('gender') is-invalid @enderror"
                                id="gender">
                            <option value="">Select Gender</option>
                            <option value="male">Male</option>
                            <option value="female">Female</option>
                        </select>
                        @error('gender')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="admission_date" class="form-label">Admission Date <span class="text-danger">*</span></label>
                        <input type="date" wire:model="admission_date"
                               class="form-control @error('admission_date') is-invalid @enderror" id="admission_date">
                        @error('admission_date')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="nok_phone" class="form-label">Next of Kin Phone <span
                                class="text-danger">*</span></label>
                        <input type="text" wire:model="nok_phone"
                               class="form-control @error('nok_phone') is-invalid @enderror" id="nok_phone">
                        @error('nok_phone')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="dob" class="form-label">Date of Birth <span class="text-danger">*</span></label>
                        <input type="date" wire:model="dob" class="form-control @error('dob') is-invalid @enderror"
                               id="dob">
                        @error('dob')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-12">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="fas fa-arrow-right me-2"></i>{{ $studentId ? 'Update & Continue' : 'Create & Continue' }}
                        </button>
                        <a href="{{ route('students.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </div>
            </form>
        @endif

        <!-- Personal Information Tab -->
        @if($currentTab === 'personal')
            <form wire:submit.prevent="savePersonal">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="phone" class="form-label">Phone</label>
                        <input type="text" wire:model="phone" class="form-control @error('phone') is-invalid @enderror"
                               id="phone">
                        @error('phone')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="place_of_birth" class="form-label">Place of Birth</label>
                        <input type="text" wire:model="place_of_birth"
                               class="form-control @error('place_of_birth') is-invalid @enderror" id="place_of_birth">
                        @error('place_of_birth')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="passport_photo" class="form-label">Passport Photo (Optional)</label>
                        <input type="file" wire:model="passport_photo" accept="image/*"
                               class="form-control @error('passport_photo') is-invalid @enderror" id="passport_photo">
                        <div class="form-text">Maximum file size: 500KB. Supported formats: JPG, PNG, GIF</div>
                        @error('passport_photo') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        
                        <!-- Loading state -->
                        <div wire:loading wire:target="passport_photo" class="mt-2">
                            <small class="text-muted">Loading preview...</small><br>
                            <div class="d-inline-flex align-items-center justify-content-center bg-light border rounded" 
                                 style="width: 100px; height: 100px;">
                                <i class="fas fa-spinner fa-spin text-primary" style="font-size: 1.5rem;"></i>
                            </div>
                        </div>
                        
                        <!-- Show preview of new file being uploaded -->
                        @if($passport_photo)
                            <div class="mt-2" wire:loading.remove wire:target="passport_photo">
                                <small class="text-muted">New photo preview:</small><br>
                                <img src="{{ $passport_photo->temporaryUrl() }}" alt="Preview" 
                                     class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                            </div>
                        @elseif($existing_profile_photo)
                            <!-- Show existing photo when no new file is selected -->
                            <div class="mt-2" wire:loading.remove wire:target="passport_photo">
                                <small class="text-muted">Current photo:</small><br>
                                <img src="{{ asset('storage/' . $existing_profile_photo) }}" alt="Current passport photo" 
                                     class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                            </div>
                        @endif
                    </div>

                    <div class="col-12 mb-3">
                        <label for="address" class="form-label">Address</label>
                        <textarea wire:model="address" class="form-control @error('address') is-invalid @enderror"
                                  id="address" rows="3" placeholder="Enter full address"></textarea>
                        @error('address')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-4 mb-3">
                        <label for="country_id" class="form-label">Country</label>
                        <div class="input-group">
                            <select class="form-select @error('country_id') is-invalid @enderror" 
                                    wire:model="country_id" wire:change="loadStates" wire:click="loadCountries" id="country_id">
                                <option value="">Select Country</option>
                                @foreach($countries as $country)
                                    <option value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                            @if($loadingCountries)
                                <span class="input-group-text">
                                    <i class="fas fa-spinner fa-spin"></i>
                                </span>
                            @endif
                        </div>
                        @error('country_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    
                    <div class="col-md-4 mb-3">
                        <label for="state_id" class="form-label">State</label>
                        <div class="input-group">
                            <select class="form-select @error('state_id') is-invalid @enderror" 
                                    wire:model="state_id" wire:change="loadCities" id="state_id" {{ !$country_id ? 'disabled' : '' }}>
                                <option value="">Select State</option>
                                @foreach($states as $state)
                                    <option value="{{ $state->id }}">{{ $state->name }}</option>
                                @endforeach
                            </select>
                            @if($loadingStates)
                                <span class="input-group-text">
                                    <i class="fas fa-spinner fa-spin"></i>
                                </span>
                            @endif
                        </div>
                        @error('state_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    
                    <div class="col-md-4 mb-3">
                        <label for="city_id" class="form-label">City</label>
                        <div class="input-group">
                            <select class="form-select @error('city_id') is-invalid @enderror" 
                                    wire:model="city_id" id="city_id" {{ !$state_id ? 'disabled' : '' }}>
                                <option value="">Select City</option>
                                @foreach($cities as $city)
                                    <option value="{{ $city->id }}">{{ $city->name }}</option>
                                @endforeach
                            </select>
                            @if($loadingCities)
                                <span class="input-group-text">
                                    <i class="fas fa-spinner fa-spin"></i>
                                </span>
                            @endif
                        </div>
                        @error('city_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-12">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="fas fa-arrow-right me-2"></i>Save & Continue
                        </button>
                        <button type="button" wire:click="switchTab('basic')" class="btn btn-secondary me-2">
                            <i class="fas fa-arrow-left me-2"></i>Back
                        </button>
                        <a href="{{ route('students.index') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </div>
            </form>
        @endif

        <!-- Academic Information Tab -->
        @if($currentTab === 'academic')
            <form wire:submit.prevent="saveAcademic">
                <div class="row">


                    <div class="col-md-6 mb-3">
                        <label for="previous_school" class="form-label">Previous School</label>
                        <input type="text" wire:model="previous_school"
                               class="form-control @error('previous_school') is-invalid @enderror" id="previous_school">
                        @error('previous_school')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="previous_class" class="form-label">Previous Class</label>
                        <input type="text" wire:model="previous_class"
                               class="form-control @error('previous_class') is-invalid @enderror" id="previous_class">
                        @error('previous_class')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-12">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="fas fa-arrow-right me-2"></i>Save & Continue
                        </button>
                        <button type="button" wire:click="switchTab('personal')" class="btn btn-secondary me-2">
                            <i class="fas fa-arrow-left me-2"></i>Back
                        </button>
                        <a href="{{ route('students.index') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </div>
            </form>
        @endif

        <!-- Guardian Information Tab -->
        @if($currentTab === 'guardian')
            <form wire:submit.prevent="saveGuardian">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="nok_name" class="form-label">Next of Kin Name</label>
                        <input type="text" wire:model="nok_name"
                               class="form-control @error('nok_name') is-invalid @enderror" id="nok_name">
                        @error('nok_name')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>


                    <div class="col-md-6 mb-3">
                        <label for="nok_relationship" class="form-label">Relationship</label>
                        <input type="text" wire:model="nok_relationship"
                               class="form-control @error('nok_relationship') is-invalid @enderror"
                               id="nok_relationship">
                        @error('nok_relationship')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="nok_address" class="form-label">Next of Kin Address</label>
                        <textarea wire:model="nok_address"
                                  class="form-control @error('nok_address') is-invalid @enderror" id="nok_address"
                                  rows="3"></textarea>
                        @error('nok_address')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="official_remarks" class="form-label">Official Remarks</label>
                        <textarea wire:model="official_remarks"
                                  class="form-control @error('official_remarks') is-invalid @enderror"
                                  id="official_remarks" rows="3"></textarea>
                        @error('official_remarks')
                        <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-12">
                        <button type="submit" class="btn btn-success me-2">
                            <i class="fas fa-check me-2"></i>Complete Registration
                        </button>
                        <button type="button" wire:click="switchTab('academic')" class="btn btn-secondary me-2">
                            <i class="fas fa-arrow-left me-2"></i>Back
                        </button>
                        <a href="{{ route('students.index') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </div>
            </form>
        @endif

        <!-- Security Tab -->
        @if($currentTab === 'security' && $studentId)
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Warning:</strong> These actions are highly sensitive! Please proceed with caution.
                    </div>
                </div>

                <!-- Student Status -->
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-title"><i class="fas fa-user-check me-2"></i>Student Status</h6>
                            <p class="card-text">Current Status:
                                <span class="badge {{ $active ? 'bg-success' : 'bg-danger' }}">
                                {{ $active ? 'Active' : 'Blocked' }}
                            </span>
                            </p>
                            <button onclick="confirmToggleStatus()"
                                    class="btn btn-sm {{ $active ? 'btn-warning' : 'btn-success' }}">
                                <i class="fas fa-{{ $active ? 'ban' : 'check' }} me-2"></i>{{ $active ? 'Block Access' : 'Activate Access' }}
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Password Management -->
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-title"><i class="fas fa-key me-2"></i>Password Management</h6>
                            <button onclick="confirmResetPassword()" class="btn btn-lg btn-warning">
                                <i class="fas fa-undo me-2"></i>Reset to Default
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Custom Password -->
                <div class="col-12 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-title"><i class="fas fa-lock me-2"></i>Set Custom Password</h6>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="new_password" class="form-label">New Password</label>
                                    <input type="password" wire:model="new_password"
                                           class="form-control @error('new_password') is-invalid @enderror"
                                           id="new_password">
                                    @error('new_password')
                                    <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="confirm_password" class="form-label">Confirm Password</label>
                                    <input type="password" wire:model="confirm_password"
                                           class="form-control @error('confirm_password') is-invalid @enderror"
                                           id="confirm_password">
                                    @error('confirm_password')
                                    <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-12">
                                    <button onclick="confirmSetPassword()" class="btn btn-primary">
                                        <i class="fas fa-save me-2"></i>Set Custom Password
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Danger Zone -->
                <div class="col-12">
                    <div class="card border-danger">
                        <div class="card-header bg-danger text-white">
                            <h6 class="mb-0"><i class="fas fa-exclamation-triangle me-2"></i>Danger Zone</h6>
                        </div>
                        <div class="card-body">
                            <p class="text-danger">Once you delete a student, there is no going back. Please be
                                certain.</p>
                            <button onclick="confirmDeleteStudent()" class="btn btn-danger">
                                <i class="fas fa-trash me-2"></i>Delete Student
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>

@if($studentId)
    <script>
        function confirmToggleStatus() {
            const action = @json($active) ? 'block' : 'activate';
            Swal.fire({
                title: `${action.charAt(0).toUpperCase() + action.slice(1)} Student?`,
                text: `Are you sure you want to ${action} this student's access?`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: 'var(--primary-color)',
                cancelButtonColor: '#6c757d',
                confirmButtonText: `Yes, ${action}!`
            }).then((result) => {
                if (result.isConfirmed) {
                    @this.
                    call('toggleStudentStatus');
                }
            });
        }

        function confirmResetPassword() {
            Swal.fire({
                title: 'Reset Password?',
                text: 'This will reset the password to the last 4 digits of the student ID.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: 'var(--primary-color)',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, reset it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    @this.
                    call('resetPassword');
                }
            });
        }

        function confirmSetPassword() {
            Swal.fire({
                title: 'Set Custom Password?',
                text: 'This will replace the current password with your custom password.',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: 'var(--primary-color)',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, set it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    @this.
                    call('setCustomPassword');
                }
            });
        }

        function confirmDeleteStudent() {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    @this.
                    call('deleteStudent');
                }
            });
        }
    </script>
@endif
