<div>
    <div class="row">
        <!-- Student Photo & Basic Info -->
        <div class="col-md-4 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <div class="mb-3">
                        @if($student->profile_photo)
                            <img src="{{ asset('storage/' . $student->profile_photo) }}" alt="{{ $student->name }}" 
                                 class="img-thumbnail" style="width: 120px; height: 120px; object-fit: cover;">
                        @else
                            <div class="bg-primary border d-inline-flex align-items-center justify-content-center" 
                                 style="width: 120px; height: 120px;">
                                <i class="fas fa-user text-white" style="font-size: 3rem;"></i>
                            </div>
                        @endif
                    </div>
                    <h4 class="card-title">{{ $student->name }}</h4>
                    <p class="text-muted">{{ $student->student_id }}</p>
                    <div class="mb-3">
                        @if($student->active)
                            <span class="badge bg-success fs-6">Active</span>
                        @else
                            <span class="badge bg-danger fs-6">Inactive</span>
                        @endif
                    </div>
                    @if($student->batch)
                        <span class="badge bg-primary">{{ $student->batch->name }}</span>
                    @else
                        <span class="badge bg-secondary">No Batch Assigned</span>
                    @endif
                </div>
            </div>
        </div>

        <!-- Detailed Information -->
        <div class="col-md-8">
            <!-- Basic Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-user me-2"></i>Basic Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>First Name:</strong> {{ $student->firstname }}</p>
                            <p><strong>Middle Name:</strong> {{ $student->middlename ?: 'N/A' }}</p>
                            <p><strong>Surname:</strong> {{ $student->surname }}</p>
                            <p><strong>Gender:</strong> {{ ucfirst($student->gender) }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Date of Birth:</strong> {{ $student->dob ? \Carbon\Carbon::parse($student->dob)->format('M d, Y') : 'N/A' }}</p>
                            <p><strong>Place of Birth:</strong> {{ $student->place_of_birth ?: 'N/A' }}</p>
                            <p><strong>Admission Date:</strong> {{ $student->admission_date ? \Carbon\Carbon::parse($student->admission_date)->format('M d, Y') : 'N/A' }}</p>
                            <p><strong>Age:</strong> {{ $student->dob ? \Carbon\Carbon::parse($student->dob)->age . ' years' : 'N/A' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-address-card me-2"></i>Contact Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Email:</strong> {{ $student->email ?: 'N/A' }}</p>
                            <p><strong>Phone:</strong> {{ $student->phone ?: 'N/A' }}</p>
                            <p><strong>Address:</strong> {{ $student->address ?: 'N/A' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Country:</strong> {{ $student->country->name ?? 'N/A' }}</p>
                            <p><strong>State:</strong> {{ $student->state->name ?? 'N/A' }}</p>
                            <p><strong>City:</strong> {{ $student->city->name ?? 'N/A' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Academic Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-graduation-cap me-2"></i>Academic Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Current Batch:</strong> {{ $student->batch->name ?? 'Not Assigned' }}</p>
                            <p><strong>Previous School:</strong> {{ $student->previous_school ?: 'N/A' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Previous Class:</strong> {{ $student->previous_class ?: 'N/A' }}</p>
                            <p><strong>Student Status:</strong> 
                                @if($student->active)
                                    <span class="text-success">Active</span>
                                @else
                                    <span class="text-danger">Inactive</span>
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Guardian Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-users me-2"></i>Guardian Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Next of Kin Name:</strong> {{ $student->nok_name ?: 'N/A' }}</p>
                            <p><strong>Relationship:</strong> {{ $student->nok_relationship ?: 'N/A' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>NOK Phone:</strong> {{ $student->nok_phone ?: 'N/A' }}</p>
                            <p><strong>NOK Address:</strong> {{ $student->nok_address ?: 'N/A' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Official Remarks -->
            @if($student->official_remarks)
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-clipboard me-2"></i>Official Remarks</h5>
                    </div>
                    <div class="card-body">
                        <p>{{ $student->official_remarks }}</p>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>