<div>
    <div class="card border-0">
        <div class="card-header border-0 p-0">
            <h4 class="card-title mb-0">My Annual Results</h4>
        </div>
        <div class="card-body p-0">
            @if($years->count() > 0)
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Academic Year</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($years as $year)
                                <tr>
                                    <td>{{ $year }}/{{ $year + 1 }}</td>
                                    <td>
                                        <span class="badge bg-success">Available</span>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column flex-md-row gap-1 gap-md-2">
                                            <a href="{{ route('student.results.view-annual', $year) }}" 
                                               class="btn btn-sm btn-primary">
                                                <i class="fas fa-eye me-2"></i>View
                                            </a>
                                            <a href="{{ route('student.results.print-annual', $year) }}" 
                                               class="btn btn-sm btn-secondary" 
                                               onclick="window.open(this.href, 'printAnnualResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                                                <i class="fas fa-print me-2"></i>Print
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-calendar-alt fa-3x text-muted mb-3"></i>
                    <h5>No Annual Results Available</h5>
                    <p class="text-muted">Your annual results will appear here once they are compiled.</p>
                </div>
            @endif
        </div>
    </div>
</div>