<div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title mb-0">Payment Details</h4>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6>Payment Information</h6>
                    <table class="table table-borderless">
                        <tr>
                            <td><strong>Description:</strong></td>
                            <td>{{ $paymentRequest->description }}</td>
                        </tr>
                        <tr>
                            <td><strong>Amount:</strong></td>
                            <td>{{ $paymentRequest->currency }} {{ number_format($paymentRequest->amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td>
                                @if($paymentRequest->status === 'paid')
                                    <span class="badge bg-success">Paid</span>
                                @elseif($paymentRequest->status === 'partial_payment')
                                    <span class="badge bg-warning">Partial Payment</span>
                                @elseif($paymentRequest->status === 'processing')
                                    <span class="badge bg-info">Processing</span>
                                @else
                                    <span class="badge bg-danger">Unpaid</span>
                                @endif
                            </td>
                        </tr>
                        @if($paymentRequest->status === 'partial_payment')
                            <tr>
                                <td><strong>Amount Paid:</strong></td>
                                <td>{{ $paymentRequest->currency }} {{ number_format($paymentRequest->amount_paid, 2) }}</td>
                            </tr>
                            <tr>
                                <td><strong>Balance:</strong></td>
                                <td>{{ $paymentRequest->currency }} {{ number_format($paymentRequest->amount - $paymentRequest->amount_paid, 2) }}</td>
                            </tr>
                        @endif
                    </table>
                </div>

                <div class="col-md-6">
                    <h6>School Account Details</h6>
                    @if($accountDetails && count($accountDetails) > 0)
                        @foreach($accountDetails as $account)
                            <div class="card mb-3">
                                <div class="card-body">
                                    <p class="mb-1"><strong>Bank:</strong> {{ $account['bank_name'] }}</p>
                                    <p class="mb-1"><strong>Account Name:</strong> {{ $account['account_name'] }}</p>
                                    <p class="mb-1"><strong>Account Number:</strong> {{ $account['account_number'] }}</p>
                                    <p class="mb-0"><strong>Currency:</strong> {{ $account['currency'] }}</p>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            No account details available. Please contact the school administration.
                        </div>
                    @endif
                </div>
            </div>

            @if($paymentRequest->status !== 'paid' && $paymentRequest->status !== 'processing')
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="alert alert-info">
                            <h6><i class="fas fa-info-circle me-2"></i>Payment Instructions</h6>
                            <ol class="mb-0">
                                <li>Transfer the exact amount to any of the school accounts above</li>
                                <li>Use your Student ID ({{ auth()->user()->student_id }}) as the transfer reference</li>
                                <li>Click "I have paid" button below after completing the transfer</li>
                                <li>Keep your transfer receipt for verification</li>
                            </ol>
                        </div>
                        
                        <div class="text-center">
                            <button wire:click="confirmPayment" class="btn btn-success btn-lg">
                                <i class="fas fa-check me-2"></i>I have paid
                            </button>
                        </div>
                    </div>
                </div>
            @elseif($paymentRequest->status === 'processing')
                <div class="alert alert-info text-center">
                    <i class="fas fa-clock me-2"></i>
                    Your payment is being processed. We will update the status once verified.
                </div>
            @else
                <div class="alert alert-success text-center">
                    <i class="fas fa-check-circle me-2"></i>
                    This payment has been completed successfully.
                </div>
            @endif
        </div>
    </div>
</div>