<div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title mb-0">Pending Payments</h4>
        </div>
        <div class="card-body">
            @if($paymentRequests->count() > 0)
                <div class="table-responsive d-none d-md-block">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Title</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($paymentRequests as $request)
                                <tr>
                                    <td>{{ $request->title }}</td>
                                    <td>{{ $request->currency_symbol }}{{ number_format($request->amount, 0) }}</td>
                                    <td>
                                        @if($request->status === 'paid')
                                            <span class="badge bg-success">Paid</span>
                                        @elseif($request->status === 'partial_payment')
                                            <span class="badge bg-warning">Partial Payment</span>
                                        @elseif($request->status === 'processing')
                                            <span class="badge bg-info">Processing</span>
                                        @else
                                            <span class="badge bg-danger">Unpaid</span>
                                        @endif
                                    </td>
                                    <td>{{ $request->created_at->format('M d, Y') }}</td>
                                    <td>
                                        @if($request->status !== 'paid')
                                            <button wire:click="makePayment({{ $request->id }})" 
                                                    class="btn btn-sm btn-primary">
                                                <i class="fas fa-credit-card me-1"></i>Pay Now
                                            </button>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Mobile view -->
                <div class="d-md-none">
                    @foreach($paymentRequests as $request)
                        <div class="card mb-3">
                            <div class="card-body">
                                <h6 class="card-title">{{ $request->title }}</h6>
                                <p class="card-text">
                                    <strong>Amount:</strong> {{ $request->currency_symbol }}{{ number_format($request->amount, 0) }}<br>
                                    <strong>Status:</strong> 
                                    @if($request->status === 'paid')
                                        <span class="badge bg-success">Paid</span>
                                    @elseif($request->status === 'partial_payment')
                                        <span class="badge bg-warning">Partial Payment</span>
                                    @elseif($request->status === 'processing')
                                        <span class="badge bg-info">Processing</span>
                                    @else
                                        <span class="badge bg-danger">Unpaid</span>
                                    @endif
                                    <br>
                                    <strong>Date:</strong> {{ $request->created_at->format('M d, Y') }}
                                </p>
                                @if($request->status !== 'paid')
                                    <button wire:click="makePayment({{ $request->id }})" 
                                            class="btn btn-sm btn-primary">
                                        <i class="fas fa-credit-card me-1"></i>Pay Now
                                    </button>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>

                {{ $paymentRequests->links('custom.pagination') }}
            @else
                <div class="text-center py-4">
                    <i class="fas fa-money-bill-wave fa-3x text-muted mb-3"></i>
                    <h5>No Pending Payments</h5>
                    <p class="text-muted">You have no pending payments at this time.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Payment History -->
    <div class="card mt-4">
        <div class="card-header">
            <h4 class="card-title mb-0">Payment History</h4>
        </div>
        <div class="card-body">
            @if($paymentHistory->count() > 0)
                <div class="table-responsive d-none d-md-block">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Payment ID</th>
                                <th>Title</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($paymentHistory as $payment)
                                <tr>
                                    <td>{{ $payment->payment_id }}</td>
                                    <td>{{ $payment->paymentRequest->title ?? 'N/A' }}</td>
                                    <td>{{ $payment->currency_symbol }}{{ number_format($payment->amount) }}</td>
                                    <td>
                                        @if($payment->status === 'successful')
                                            <span class="badge bg-success">Paid</span>
                                        @elseif($payment->status === 'partial')
                                            <span class="badge bg-warning">Partial</span>
                                        @elseif($payment->status === 'processing')
                                            <span class="badge bg-info">Processing</span>
                                        @elseif($payment->status === 'failed')
                                            <span class="badge bg-danger">Failed</span>
                                        @else
                                            <span class="badge bg-secondary">Pending</span>
                                        @endif
                                    </td>
                                    <td>{{ $payment->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <button wire:click="viewNotes({{ $payment->id }})" 
                                                class="btn btn-sm btn-outline-primary me-1 my-1">
                                            <i class="fas fa-eye me-1"></i>Notes
                                        </button>
                                        @if($payment->status === 'successful')
                                            <a href="{{ route('student.payments.receipt', $payment->payment_id) }}" 
                                               class="btn btn-sm btn-success my-1">
                                                <i class="fas fa-receipt me-1"></i>Receipt
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Mobile view -->
                <div class="d-md-none">
                    @foreach($paymentHistory as $payment)
                        <div class="card mb-3">
                            <div class="card-body">
                                <h6 class="card-title">{{ $payment->paymentRequest->title ?? 'N/A' }}</h6>
                                <p class="card-text">
                                    <strong>Payment ID:</strong> {{ $payment->payment_id }}<br>
                                    <strong>Amount:</strong> {{ $payment->currency_symbol }}{{ number_format($payment->amount) }}<br>
                                    <strong>Status:</strong> 
                                    @if($payment->status === 'successful')
                                        <span class="badge bg-success">Paid</span>
                                    @elseif($payment->status === 'partial')
                                        <span class="badge bg-warning">Partial</span>
                                    @elseif($payment->status === 'processing')
                                        <span class="badge bg-info">Processing</span>
                                    @elseif($payment->status === 'failed')
                                        <span class="badge bg-danger">Failed</span>
                                    @else
                                        <span class="badge bg-secondary">Pending</span>
                                    @endif
                                    <br>
                                    <strong>Date:</strong> {{ $payment->created_at->format('M d, Y') }}
                                </p>
                                <button wire:click="viewNotes({{ $payment->id }})" 
                                        class="btn btn-sm btn-outline-primary me-1 my-1">
                                    <i class="fas fa-eye me-1"></i>Notes
                                </button>
                                @if($payment->status === 'successful')
                                    <a href="{{ route('student.payments.receipt', $payment->payment_id) }}" 
                                       class="btn btn-sm btn-success my-1">
                                        <i class="fas fa-receipt me-1"></i>Receipt
                                    </a>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>

                {{ $paymentHistory->links('custom.pagination', ['pageName' => 'historyPage']) }}
            @else
                <div class="text-center py-4">
                    <i class="fas fa-history fa-3x text-muted mb-3"></i>
                    <h5>No Payment History</h5>
                    <p class="text-muted">You have no payment history at this time.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Payment Modal -->
    @if($showPaymentModal)
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title text-light">Make Payment</h5>
                        <button type="button" class="btn-close" wire:click="closeModal"></button>
                    </div>
                    <div class="modal-body">
                        @if($selectedPaymentRequest)
                            <div class="mb-4">
                                <h4>{{ $selectedPaymentRequest->title }}</h4>
                                <p class="text-muted">{{ $selectedPaymentRequest->description }}</p>
                                <p><strong>Amount:</strong> {{ $selectedPaymentRequest->currency_symbol }}{{ number_format($selectedPaymentRequest->amount, 0) }}</p>
                            </div>

                            @if($hasPendingPayment)
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <strong>Payment Pending:</strong> You have already submitted a payment confirmation for this request. Please remember to make the transfer to one of the designated accounts below.
                                </div>
                            @else
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    <strong>Payment Instructions:</strong> Please make a transfer to any of the accounts below, then click "I have paid" to confirm your payment.
                                </div>
                            @endif

                            @if(count($schoolAccounts) > 0)
                                <h6 class="mb-3">School Account Details</h6>
                                <div class="row">
                                    @foreach($schoolAccounts as $index => $account)
                                        @if(!empty($account['account_number']) && !empty($account['account_name']))
                                            <div class="col-md-6 mb-3">
                                                <div class="card">
                                                    <div class="card-body">
                                                        <h6 class="card-title">{{ $account['bank_name'] ?? 'Bank Account ' . ($index + 1) }}</h6>
                                                        <p class="card-text mb-1"><strong>Account Name:</strong> {{ $account['account_name'] }}</p>
                                                        <p class="card-text mb-1"><strong>Account Number:</strong> {{ $account['account_number'] }}</p>
                                                        <p class="card-text mb-0"><strong>Currency:</strong> {{ $account['currency'] ?? 'NGN' }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            @else
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    No account details available. Please contact the school administration.
                                </div>
                            @endif
                        @endif
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeModal">Close</button>
                        <button type="button" class="btn btn-primary @if($hasPendingPayment) opacity-50 @endif" 
                                wire:click="confirmPayment" @if($hasPendingPayment) disabled @endif wire:loading.attr="disabled">
                            <i class="fas fa-check me-2" wire:loading.remove wire:target="confirmPayment"></i>
                            <i class="fas fa-spinner fa-spin me-2" wire:loading wire:target="confirmPayment"></i>
                            <span wire:loading.remove wire:target="confirmPayment">I have paid</span>
                            <span wire:loading wire:target="confirmPayment">Processing...</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif

    <!-- Notes Modal -->
    @if($showNotesModal)
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title text-light">Payment Notes</h5>
                        <button type="button" class="btn-close" wire:click="closeNotesModal"></button>
                    </div>
                    <div class="modal-body">
                        @if($selectedPayment)
                            <div class="mb-3">
                                <strong>Payment ID:</strong> {{ $selectedPayment->payment_id }}
                            </div>
                            <div class="mb-3">
                                <strong>Amount:</strong> {{ $selectedPayment->currency_symbol }}{{ number_format($selectedPayment->amount) }}
                            </div>
                            <div class="mb-3">
                                <strong>Status:</strong> 
                                @if($selectedPayment->status === 'successful')
                                    <span class="badge bg-success">Paid</span>
                                @elseif($selectedPayment->status === 'partial')
                                    <span class="badge bg-warning">Partial</span>
                                @elseif($selectedPayment->status === 'processing')
                                    <span class="badge bg-info">Processing</span>
                                @elseif($selectedPayment->status === 'failed')
                                    <span class="badge bg-danger">Failed</span>
                                @else
                                    <span class="badge bg-secondary">Pending</span>
                                @endif
                            </div>
                            <div class="mb-3">
                                <strong>Date:</strong> {{ $selectedPayment->created_at->format('M d, Y g:i A') }}
                            </div>
                            <div>
                                <strong>Notes:</strong>
                                <div class="mt-2 p-3 bg-light rounded">
                                    {{ $selectedPayment->notes ?: 'No notes available.' }}
                                </div>
                            </div>
                        @endif
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeNotesModal">Close</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif
</div>