<div>
    <div class="row mb-3">
        <div class="col-md-6">
            <input type="text" wire:model.live="search" class="form-control" placeholder="Search subjects...">
        </div>
    </div>

    <div class="d-none d-md-block">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Classes Assigned</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                @forelse($subjects as $index => $subject)
                    <tr>
                        <td>{{ $subjects->firstItem() + $index }}</td>
                        <td>
                            @if($editingSubject && $editingSubject->id === $subject->id)
                                <input type="text" wire:model="name" class="form-control form-control-sm">
                            @else
                                {{ $subject->name }}
                            @endif
                        </td>
                        <td>{{ $subject->schoolClasses->count() }}</td>
                        <td>
                            @if($editingSubject && $editingSubject->id === $subject->id)
                                <button wire:click="update" class="btn btn-success btn-sm me-2">
                                    <i class="fas fa-check"></i>
                                </button>
                                <button wire:click="cancelEdit" class="btn btn-secondary btn-sm">
                                    <i class="fas fa-times"></i>
                                </button>
                            @else
                                <button wire:click="edit({{ $subject->id }})" class="btn btn-primary btn-sm me-2">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button wire:click="confirmDelete({{ $subject->id }})"
                                        class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i>
                                </button>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center">No subjects found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="d-md-none">
        @forelse($subjects as $index => $subject)
            <div class="accordion mb-2" id="subject-{{ $subject->id }}" wire:ignore.self>
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button
                            class="accordion-button {{ $editingSubject && $editingSubject->id === $subject->id ? '' : 'collapsed' }} d-flex align-items-center"
                            type="button"
                            data-bs-toggle="collapse" data-bs-target="#collapse-{{ $subject->id }}"
                            onclick="toggleChevron('subject-{{ $subject->id }}')">
                            <div class="flex-grow-1">
                                <div class="fw-bold">{{ $subjects->firstItem() + $index }}. {{ $subject->name }}</div>
                            </div>
                            <i class="fas fa-chevron-down accordion-chevron ms-2"></i>
                        </button>
                    </h2>
                    <div id="collapse-{{ $subject->id }}"
                         class="accordion-collapse collapse {{ $editingSubject && $editingSubject->id === $subject->id ? 'show' : '' }}">
                        <div class="accordion-body">
                            @if($editingSubject && $editingSubject->id === $subject->id)
                                <div class="mb-3">
                                    <label class="form-label">Subject Name</label>
                                    <input type="text" wire:model="name" class="form-control form-control-sm">
                                </div>
                            @endif
                            <div class="row g-2 mb-3">
                                <div class="col-12">
                                    <small class="text-muted">Classes Assigned</small>
                                    <div>{{ $subject->schoolClasses->count() }}</div>
                                </div>
                            </div>
                            <div class="d-flex gap-2 flex-wrap">
                                @if($editingSubject && $editingSubject->id === $subject->id)
                                    <button wire:click="update" class="btn btn-success btn-sm"
                                            onclick="event.stopPropagation()">
                                        <i class="fas fa-check me-2"></i>Save
                                    </button>
                                    <button wire:click="cancelEdit" class="btn btn-secondary btn-sm"
                                            onclick="event.stopPropagation()">
                                        <i class="fas fa-times me-2"></i>Cancel
                                    </button>
                                @else
                                    <button wire:click="edit({{ $subject->id }})" class="btn btn-primary btn-sm"
                                            onclick="event.stopPropagation()">
                                        <i class="fas fa-edit me-2"></i>Edit
                                    </button>
                                    <button wire:click="confirmDelete({{ $subject->id }})" class="btn btn-danger btn-sm"
                                            onclick="event.stopPropagation()">
                                        <i class="fas fa-trash me-2"></i>Delete
                                    </button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <p class="text-center">No subjects found.</p>
        @endforelse
    </div>

    {{ $subjects->links('custom.pagination') }}
</div>


