<div>
    <form wire:submit.prevent="assignClasses">
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="selectedTeacher" class="form-label">Select Teacher <span class="text-danger">*</span></label>
                <select class="form-select @error('selectedTeacher') is-invalid @enderror" 
                        wire:model.live="selectedTeacher" id="selectedTeacher">
                    <option value="">Choose a teacher...</option>
                    @foreach($teachers as $teacher)
                        <option value="{{ $teacher->id }}">{{ $teacher->name }}</option>
                    @endforeach
                </select>
                @error('selectedTeacher') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>
        </div>

        @if($selectedTeacher)
            <div class="mb-3">
                <label class="form-label">Assign Classes</label>
                <div class="border rounded p-3" style="max-height: 300px; overflow-y: auto;">
                    @foreach($classes as $class)
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="checkbox" 
                                   wire:model="selectedClasses" 
                                   value="{{ $class->id }}" 
                                   id="class{{ $class->id }}">
                            <label class="form-check-label" for="class{{ $class->id }}">
                                {{ $class->display_name }}
                            </label>
                        </div>
                    @endforeach
                </div>
            </div>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save me-2"></i>Assign Classes
            </button>
        @endif
    </form>
</div>