@extends('layouts.school-portal')

@section('title', 'Payroll Management')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Payroll Management</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <div class="card bg-primary text-white">
                                    <div class="card-body">
                                        <h5 class="text-light">Staff Salaries</h5>
                                        <p>Manage staff salary information</p>
                                        <a href="{{ route('payroll.staff-salaries') }}" class="btn btn-light btn-sm">
                                            <i class="fas fa-users me-2"></i>Manage
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="card bg-success text-white">
                                    <div class="card-body">
                                        <h5 class="text-light">Salary History</h5>
                                        <p>Generate and manage salary records</p>
                                        <a href="{{ route('payroll.salary-history') }}" class="btn btn-light btn-sm">
                                            <i class="fas fa-history me-2"></i>Manage
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="card bg-info text-white">
                                    <div class="card-body">
                                        <h5 class="text-light">My Salary</h5>
                                        <p>View your salary history</p>
                                        <a href="{{ route('dashboard') }}" class="btn btn-light btn-sm">
                                            <i class="fas fa-eye me-2"></i>View
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
