@extends('layouts.school-portal')

@section('title', 'Promote by Batch')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <!-- Mobile Back Button Row -->
                    <div class="d-md-none mb-3 text-end">
                        <a href="{{ route('promotion.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Back
                        </a>
                    </div>
                    
                    <!-- Desktop Layout -->
                    <div class="d-none d-md-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="card-title mb-0">Promote Students by Batch</h4>
                            <p class="text-muted mb-0">Promote all students in a specific batch</p>
                        </div>
                        <a href="{{ route('promotion.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Back
                        </a>
                    </div>
                    
                    <!-- Mobile Heading -->
                    <div class="d-md-none">
                        <h4 class="card-title mb-0">Promote Students by Batch</h4>
                        <p class="text-muted mb-0">Promote all students in a specific batch</p>
                    </div>
                </div>
                <div class="card-body">
                    <livewire:promotion-by-batch />
                </div>
            </div>
        </div>
    </div>
</div>
@endsection