@extends('layouts.school-portal')

@section('title', 'Student Promotion')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">Student Promotion</h4>
                    <p class="text-muted mb-0">Promote or demote students between classes</p>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <div class="card h-100">
                                <div class="card-body text-center">
                                    <i class="fas fa-users fa-3x text-primary mb-3"></i>
                                    <h5>By Class</h5>
                                    <p class="text-muted">Promote all students in a class to another class</p>
                                    <a href="{{ route('promotion.by-class') }}" class="btn btn-primary">
                                        <i class="fas fa-arrow-right me-2"></i>Promote by Class
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4 mb-3">
                            <div class="card h-100">
                                <div class="card-body text-center">
                                    <i class="fas fa-layer-group fa-3x text-success mb-3"></i>
                                    <h5>By Batch</h5>
                                    <p class="text-muted">Promote all students in a specific batch</p>
                                    <a href="{{ route('promotion.by-batch') }}" class="btn btn-success">
                                        <i class="fas fa-arrow-right me-2"></i>Promote by Batch
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4 mb-3">
                            <div class="card h-100">
                                <div class="card-body text-center">
                                    <i class="fas fa-user fa-3x text-info mb-3"></i>
                                    <h5>Individual Student</h5>
                                    <p class="text-muted">Promote or demote a single student</p>
                                    <a href="{{ route('promotion.individual') }}" class="btn btn-info">
                                        <i class="fas fa-arrow-right me-2"></i>Individual Promotion
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection