@php
    $helpers = app('App\Services\AnnualResultService')->getCalculationHelpers($data['sessions'], $data['subjects'], $data['studentData']);
    $annualMaxTotal = $helpers['annual_max_total'];
    $correctedAnnualAverage = $helpers['corrected_annual_average'];
    $promotionStatus = $helpers['promotion_status'];
@endphp

<!-- Student Info Header -->
<div class="row mb-4">
    <div class="col-md-8">
        <div class="card bg-light">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <h5 class="mb-3">{{ $data['student']->firstname }} {{ $data['student']->middlename }} {{ $data['student']->surname }}</h5>
                        <p class="mb-1"><strong>Student ID:</strong> {{ $data['student']->student_id ?? 'N/A' }}</p>
                        <p class="mb-1"><strong>Class:</strong> {{ $data['class']->alias ?: $data['class']->name }}</p>
                        <p class="mb-1"><strong>Academic Year:</strong> {{ $data['year'] }}/{{ $data['year'] + 1 }}</p>
                        <p class="mb-0"><strong>Gender:</strong> {{ ucfirst($data['student']->gender ?? 'N/A') }}</p>
                    </div>
                    <div class="col-md-4 text-center">
                        <img src="{{ $data['student']->profile_photo ? asset('storage/' . $data['student']->profile_photo) : asset('images/user-avatar.png') }}" 
                             alt="Student Photo" class="img-thumbnail" style="width: 100px; height: 100px; object-fit: cover;">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <!-- Summary Cards -->
        <div class="row">
            <div class="col-6 mb-2">
                <div class="card text-center bg-primary text-white">
                    <div class="card-body py-2">
                        <span class="fw-bold fs-6 text-light d-block mb-1">Annual Total</span>
                        <h5 class="mb-0 text-light">{{ $data['studentData']['annual_grand_total'] }}/{{ $annualMaxTotal }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-6 mb-2">
                <div class="card text-center bg-success text-white">
                    <div class="card-body py-2">
                        <span class="fw-bold fs-6 text-light d-block mb-1">Annual Score %</span>
                        <h5 class="mb-0 text-light">{{ $correctedAnnualAverage }}%</h5>
                    </div>
                </div>
            </div>
            <div class="col-6 mb-2">
                <div class="card text-center bg-info text-white">
                    <div class="card-body py-2">
                        <span class="fw-bold fs-6 text-light d-block mb-1">Sessions</span>
                        <h5 class="mb-0 text-light">{{ $data['studentData']['session_count'] }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-6 mb-2">
                <div class="card text-center {{ $promotionStatus['is_promoted'] ? 'bg-success' : 'bg-danger' }} text-white">
                    <div class="card-body py-2">
                        <span class="fw-bold fs-6 text-light d-block mb-1">Status</span>
                        <h5 class="mb-0 text-light">{{ $promotionStatus['comment'] }}</h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Results Table -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <span class="fw-bold fs-5 d-block mb-0">Session-wise Results</span>
            </div>
            <div class="card-body">
                <!-- Desktop View -->
                <div class="d-none d-lg-block">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped text-center align-middle">
                            <thead class="table-dark">
                            <tr>
                                <th rowspan="2">Subject</th>
                                @foreach($data['sessions'] as $session)
                                    <th colspan="4" class="text-center">{{ $session->name }}</th>
                                @endforeach
                            </tr>
                            <tr>
                                @foreach($data['sessions'] as $session)
                                    <th>CA</th>
                                    <th>Exam</th>
                                    <th>Total</th>
                                    <th>Grade</th>
                                @endforeach
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($data['subjects'] as $subject)
                                <tr>
                                    <td class="text-start"><strong>{{ $subject->display_name }}</strong></td>
                                    @foreach($data['sessions'] as $session)
                                        @php
                                            $result = $data['studentData']['sessions'][$session->id]['subjects'][$subject->id] ?? null;
                                        @endphp
                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['ca_score'] ?? 0) }}</td>
                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['exam_score'] ?? 0) }}</td>
                                        <td><strong>{{ app('App\Services\AnnualResultService')->formatResultValue($result['total'] ?? 0) }}</strong></td>
                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['grade'] ?? 'F') }}</td>
                                    @endforeach
                                </tr>
                            @endforeach
                            <tr class="table-info">
                                <td class="text-start"><strong>Session Total</strong></td>
                                @foreach($data['sessions'] as $session)
                                    <td></td>
                                    <td></td>
                                    @php
                                        $sessionMaxTotal = app('App\Services\AnnualResultService')->calculateSessionMaxTotal($session->id, $data['subjects'], $data['studentData']);
                                    @endphp
                                    <td><strong>{{ $data['studentData']['sessions'][$session->id]['grand_total'] }}/{{ $sessionMaxTotal }}</strong></td>
                                    <td></td>
                                @endforeach
                            </tr>
                            <tr class="table-warning">
                                <td class="text-start"><strong>Session Average</strong></td>
                                @foreach($data['sessions'] as $session)
                                    <td></td>
                                    <td></td>
                                    <td><strong>{{ $data['studentData']['sessions'][$session->id]['average'] }}</strong></td>
                                    <td></td>
                                @endforeach
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Mobile View -->
                <div class="d-lg-none">
                    <div class="accordion" id="sessionAccordion">
                        @foreach($data['sessions'] as $index => $session)
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse"
                                            data-bs-target="#collapse{{ $index }}" aria-expanded="false">
                                        <strong>{{ $session->name }}</strong>
                                        <span class="ms-auto me-3">
                                            @php
                                                $sessionMaxTotal = app('App\Services\AnnualResultService')->calculateSessionMaxTotal($session->id, $data['subjects'], $data['studentData']);
                                            @endphp
                                            <small class="text-muted">Total: {{ $data['studentData']['sessions'][$session->id]['grand_total'] }}/{{ $sessionMaxTotal }} ({{ $data['studentData']['sessions'][$session->id]['average'] }}%)</small>
                                        </span>
                                    </button>
                                </h2>
                                <div id="collapse{{ $index }}" class="accordion-collapse collapse"
                                     data-bs-parent="#sessionAccordion">
                                    <div class="accordion-body">
                                        <div class="table-responsive">
                                            <table class="table table-sm">
                                                <thead>
                                                <tr>
                                                    <th>Subject</th>
                                                    <th>CA</th>
                                                    <th>Exam</th>
                                                    <th>Total</th>
                                                    <th>Grade</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($data['subjects'] as $subject)
                                                    @php
                                                        $result = $data['studentData']['sessions'][$session->id]['subjects'][$subject->id] ?? null;
                                                    @endphp
                                                    <tr>
                                                        <td>{{ $subject->display_name }}</td>
                                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['ca_score'] ?? 0) }}</td>
                                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['exam_score'] ?? 0) }}</td>
                                                        <td><strong>{{ app('App\Services\AnnualResultService')->formatResultValue($result['total'] ?? 0) }}</strong></td>
                                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['grade'] ?? 'F') }}</td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@if($data['approval'])
<!-- Affective Traits and Psychomotor Skills -->
<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <span class="fw-bold fs-6 text-white d-block mb-0">Affective Traits</span>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6"><strong>Punctuality:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->punctuality) }}/5</div>
                    <div class="col-6"><strong>Mental Alertness:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->mental_alertness) }}/5</div>
                    <div class="col-6"><strong>Attentiveness:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->attentiveness) }}/5</div>
                    <div class="col-6"><strong>Respect:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->respect) }}/5</div>
                    <div class="col-6"><strong>Neatness:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->neatness) }}/5</div>
                    <div class="col-6"><strong>Politeness:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->politeness) }}/5</div>
                    <div class="col-6"><strong>Honesty:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->honesty) }}/5</div>
                    <div class="col-6"><strong>Relationship with Peers:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->relationship_with_peers) }}/5</div>
                    <div class="col-6"><strong>Attitude to School:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->attitude_to_school) }}/5</div>
                    <div class="col-6"><strong>Teamwork:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->teamwork) }}/5</div>
                    <div class="col-6"><strong>Completes Work Promptly:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->completes_school_work_promptly) }}/5</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-success text-white">
                <span class="fw-bold fs-6 text-white d-block mb-0">Psychomotor Skills</span>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6"><strong>Reading:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->reading) }}/5</div>
                    <div class="col-6"><strong>Verbal Fluency/Diction:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->verbal_fluency_diction) }}/5</div>
                    <div class="col-6"><strong>Handwriting:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->handwriting) }}/5</div>
                    <div class="col-6"><strong>Musical Skills:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->musical_skills) }}/5</div>
                    <div class="col-6"><strong>Creative Arts:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->creative_arts) }}/5</div>
                    <div class="col-6"><strong>Physical Education:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->physical_education) }}/5</div>
                    <div class="col-6"><strong>General Reasoning:</strong></div>
                    <div class="col-6">{{ intval($data['approval']->general_reasoning) }}/5</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Principal's Remarks -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-info text-white">
                <span class="fw-bold fs-6 text-white d-block mb-0">Head Teacher's Remarks</span>
            </div>
            <div class="card-body">
                <p class="mb-0">{{ $data['approval']->principal_remarks }}</p>
            </div>
        </div>
    </div>
</div>
@endif

<!-- Grade Distribution -->
<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <span class="fw-bold fs-6 d-block mb-0">Annual Grade Distribution</span>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    @foreach(['A', 'B', 'C', 'D', 'E', 'F'] as $grade)
                        <div class="col-2 mb-2">
                            <div class="badge bg-{{ $grade === 'A' ? 'success' : ($grade === 'F' ? 'danger' : 'secondary') }} p-2 w-100">
                                <div>{{ $grade }}</div>
                                <div class="h6 mb-0">{{ $data['studentData']['annual_grades'][$grade] }}</div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <span class="fw-bold fs-6 d-block mb-0">Annual Summary</span>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6"><strong>Annual Total:</strong></div>
                    <div class="col-6">{{ $data['studentData']['annual_grand_total'] }}/{{ $annualMaxTotal }}</div>
                    <div class="col-6"><strong>Annual Score %:</strong></div>
                    <div class="col-6">{{ $correctedAnnualAverage }}%</div>
                    <div class="col-6"><strong>Sessions Completed:</strong></div>
                    <div class="col-6">{{ $data['studentData']['session_count'] }}</div>
                    <div class="col-6"><strong>Total Subjects:</strong></div>
                    <div class="col-6">{{ count($data['subjects']) }}</div>
                </div>
            </div>
        </div>
    </div>
</div>

@if(isset($qrCode) && $qrCode)
<!-- QR Code -->
<div class="row mt-4">
    <div class="col-12 text-center">
        <div class="card">
            <div class="card-body">
                {!! $qrCode !!}
                <p class="mt-2 text-muted">Scan to verify result authenticity</p>
            </div>
        </div>
    </div>
</div>
@endif