<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Master List - {{ $data['session']->name }} {{ $data['session']->start_year }}/{{ $data['session']->end_year }}</title>
    <link href="{{ asset('vendor/bootstrap-5.3.7.min.css') }}" rel="stylesheet">
    <link href="{{ asset('vendor/fontawesome-6.7.2/css/all.min.css') }}" rel="stylesheet">
    <link href="{{ asset('css/school-portal.css') }}" rel="stylesheet">
    <style>
        @page {
            size: A4 landscape;
            margin: 0.3in;
        }

        .report-title {
            font-size: 12px;
            font-style: italic;
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            height: 25px;
            padding-top: 5px;
            margin-top: 0px;
            background-color: #757575 !important;
        }

        .add-border {
            border: 1px solid #CCC;
        }

        .header-flex {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
        }

        .school-logo {
            width: auto;
            height: 60px;
            border-radius: 5px;
            flex-shrink: 0;
        }

        .school-info {
            text-align: center;
        }

        .result-header {
            font-size: 8px;
            background-color: #757575 !important;
            padding: 2px !important;
        }
        
        .result-header.fontwhite {
            background-color: #757575 !important;
            color: #FFF !important;
        }

        .fontwhite {
            color: #FFF !important;
        }

        .result-body {
            font-size: 7px;
            font-weight: bolder;
            padding: 2px !important;
        }

        .result-body2 {
            font-size: 6px;
            font-weight: normal;
        }

        .report-body2 {
            font-size: 8px;
            font-weight: bold;
        }

        .fontnormal {
            font-weight: normal;
        }

        .school-name {
            font-size: 14px;
            font-family: Georgia, "Times New Roman", Times, serif;
            font-weight: bolder;
            margin-bottom: 3px;
        }

        .contacts {
            font-size: 8px;
            font-weight: bold;
            margin-bottom: 2px;
        }

        .bgimage {
            background-image: url(images/signin_feild_bg.gif) !important;
            background-repeat: repeat;
            -webkit-print-color-adjust: exact;
        }

        @media print {
            .no-print {
                display: none;
            }

            body {
                margin: 0;
            }
        }
    </style>
</head>
<body>

<div class="container-fluid p-2 bgimage add-border main-container">
    <!-- Header -->
    <div class="header-flex">
        <img src="{{ asset('images/rosa-mys-logo.png') }}" alt="school logo" class="school-logo">
        <div class="school-info">
            <div class="school-name">{{ $data['school_info']['name'] }}</div>
            @if($data['school_info']['address'])
            <div class="contacts">{{ $data['school_info']['address'] }}</div>
            @endif
            <div class="contacts">
                @if($data['school_info']['website'])
                    <i class="fa fa-desktop"></i> {{ $data['school_info']['website'] }}
                @endif
                @if($data['school_info']['website'] && $data['school_info']['email']) | @endif
                @if($data['school_info']['email'])
                    <i class="fa fa-envelope"></i> {{ $data['school_info']['email'] }}
                @endif
            </div>
            @if($data['school_info']['phone_1'] || $data['school_info']['phone_2'])
            <div class="contacts">
                <i class="fa fa-phone"></i> Phone: 
                {{ $data['school_info']['phone_1'] }}
                @if($data['school_info']['phone_1'] && $data['school_info']['phone_2']) , @endif
                {{ $data['school_info']['phone_2'] }}
            </div>
            @endif
        </div>
        <div class="qr-code" style="flex-shrink: 0;">
            {!! $qrCode !!}
        </div>
    </div>

    <!-- Title -->
    <div class="text-center report-title" style="margin-top: 8px; color: white;">
        Termly Master List - {{ $data['session']->name }}
    </div>

    <!-- Description -->
    <div style="margin-top: 10px;">
        <table class="table-condensed report-body2">
            <tbody>
            <tr>
                <td><strong>Class:</strong> <span class="fontnormal">{{ $data['class']->display_name }}@if($data['batch']) - {{ $data['batch']->name }}@else (All Batches)@endif</span></td>
                <td><strong>Session:</strong> <span class="fontnormal">{{ $data['session']->start_year }}/{{ $data['session']->end_year }}</span></td>
                <td><strong>Term:</strong> <span class="fontnormal">{{ $data['session']->name }}</span></td>
                <td><strong>Total Possible Score:</strong> <span class="fontnormal">{{ count($data['subjects']) * 100 }}</span></td>
            </tr>
            </tbody>
        </table>
    </div>

    <!-- Results Table -->
    <div class="table-responsive">
        <table class="table table-condensed table-striped table-bordered" style="min-width: 100%; font-size: 0.7rem;">
                <thead>
                <tr class="result-header">
                    <td rowspan="2" align="center">Pos</td>
                    <td rowspan="2" align="center">Student Name</td>
                    <td rowspan="2" align="center">Student ID</td>
                    @foreach($data['subjects'] as $subject)
                        <td colspan="3" align="center">{{ $subject->display_name }}</td>
                    @endforeach
                    <td rowspan="2" align="center">Grand Total</td>
                    <td rowspan="2" align="center">Average</td>
                    <td colspan="6" align="center">Grades</td>
                    <td rowspan="2" align="center">Remark</td>
                </tr>
                <tr class="result-header">
                    @foreach($data['subjects'] as $subject)
                        <td align="center">CA</td>
                        <td align="center">Ex</td>
                        <td align="center">Tot</td>
                    @endforeach
                    <td align="center">A</td>
                    <td align="center">B</td>
                    <td align="center">C</td>
                    <td align="center">D</td>
                    <td align="center">E</td>
                    <td align="center">F</td>
                </tr>
                </thead>
                <tbody class="result-body" style="text-align: center; vertical-align: middle;">
                @foreach($data['masterListData'] as $studentData)
                    <tr>
                        <td><strong>{{ $studentData['position_suffix'] }}</strong></td>
                        <td nowrap="nowrap" style="text-align: left;"><strong>{{ strtoupper($studentData['student']->name) }}</strong></td>
                        <td><strong>{{ $studentData['student']->student_id }}</strong></td>
                        @foreach($data['subjects'] as $subject)
                            @php 
                                $subjectResult = $studentData['subjects'][$subject->id] ?? null;
                                $isLastSubject = $loop->last;
                            @endphp
                            <td>{{ intval($subjectResult['ca_score'] ?? 0) }}</td>
                            <td>{{ intval($subjectResult['exam_score'] ?? 0) }}</td>
                            <td style="{{ $isLastSubject ? 'border-right: 3px solid #000;' : '' }}">{{ intval($subjectResult['total'] ?? 0) }}</td>
                        @endforeach
                        <td><strong>{{ intval($studentData['grand_total']) }}</strong></td>
                        <td><strong>{{ $studentData['average'] }}</strong></td>
                        <td>{{ $studentData['grades']['A'] }}</td>
                        <td>{{ $studentData['grades']['B'] }}</td>
                        <td>{{ $studentData['grades']['C'] }}</td>
                        <td>{{ $studentData['grades']['D'] }}</td>
                        <td>{{ $studentData['grades']['E'] }}</td>
                        <td>{{ $studentData['grades']['F'] }}</td>
                        <td style="color: {{ $studentData['remark'] === 'Pass' ? 'green' : 'red' }}"><strong>{{ $studentData['remark'] }}</strong></td>
                    </tr>
                @endforeach
                </tbody>
            </table>
    </div>

    <!-- Teachers and Timestamp Section -->
    <div style="margin-top: 20px; border-top: 1px solid #ccc; padding-top: 10px;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
                <strong class="result-body">Class Teachers:</strong>
                <span class="result-body2">
                    @if($data['class']->teachers->count() > 0)
                        {{ $data['class']->teachers->pluck('name')->join(', ') }}
                    @else
                        No teachers assigned
                    @endif
                </span>
            </div>
            @php
                $signatureType = settings('signature_type', 'head_teacher');
                $showProprietor = settings('show_proprietor_signature', false);
                $showHeadTeacher = settings('show_head_teacher_signature', true);
                $proprietorName = settings('proprietor_name', 'School Proprietor');
                $headTeacherName = settings('head_teacher_name', 'Head Teacher');
            @endphp
            @if($signatureType === 'both')
                <div style="text-align: center; display: flex; gap: 20px; justify-content: center;">
                    @if($showProprietor)
                    <div>
                        <img src="{{ asset('images/proprietor-sign.jpg') }}" style="width:70px;height:35px;border-radius:3px" alt="proprietor signature" class="img-responsive">
                        <div class="result-body2" style="margin-top: 3px;">{{ $proprietorName }}</div>
                        <div class="result-body2">Proprietor</div>
                        <div class="result-body2">{{ $data['school_info']['name'] }}</div>
                    </div>
                    @endif
                    @if($showHeadTeacher)
                    <div>
                        <img src="{{ asset('images/head-teacher-sign.jpg') }}" style="width:70px;height:35px;border-radius:3px" alt="head teacher signature" class="img-responsive">
                        <div class="result-body2" style="margin-top: 3px;">{{ $headTeacherName }}</div>
                        <div class="result-body2">Head Teacher</div>
                        <div class="result-body2">{{ $data['school_info']['name'] }}</div>
                    </div>
                    @endif
                </div>
            @elseif($signatureType === 'proprietor' && $showProprietor)
                <div style="text-align: center;">
                    <img src="{{ asset('images/proprietor-sign.jpg') }}" style="width:80px;height:40px;border-radius:3px" alt="proprietor signature" class="img-responsive">
                    <div class="result-body2" style="margin-top: 3px;">{{ $proprietorName }}</div>
                    <div class="result-body2">Proprietor</div>
                    <div class="result-body2">{{ $data['school_info']['name'] }}</div>
                </div>
            @elseif($signatureType === 'head_teacher' && $showHeadTeacher)
                <div style="text-align: center;">
                    <img src="{{ asset('images/head-teacher-sign.jpg') }}" style="width:80px;height:40px;border-radius:3px" alt="head teacher signature" class="img-responsive">
                    <div class="result-body2" style="margin-top: 3px;">{{ $headTeacherName }}</div>
                    <div class="result-body2">Head Teacher</div>
                    <div class="result-body2">{{ $data['school_info']['name'] }}</div>
                </div>
            @endif
            <div>
                <span class="result-body2">Generated on: {{ now()->format('M d, Y \a\t h:i A') }}</span>
            </div>
        </div>
    </div>
</div>

<div class="no-print" style="margin-top: 30px; text-align: center;">
    <button class="btn btn-primary" onclick="window.print()">
        <i class="fa fa-print"></i> Print Master List
    </button>
    <button class="btn btn-secondary" onclick="window.close()">
        <i class="fa fa-times"></i> Close
    </button>
</div>

</body>
</html>