<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Result - {{ $data['student']->name }}</title>
    <style>
        @page {
            size: A4;
            margin: 0.5in;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif;
            font-size: 0.875rem;
            font-weight: 400;
            line-height: 1.5;
            color: #212529;
            background-color: #fff;
            margin: 0;
            padding: 0;
        }
        
        .container-fluid {
            width: 100%;
            padding-right: 0.75rem;
            padding-left: 0.75rem;
            margin-right: auto;
            margin-left: auto;
        }
        
        .row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -0.75rem;
            margin-left: -0.75rem;
        }
        
        .col-12, .col-xs-12 {
            flex: 0 0 100%;
            max-width: 100%;
            position: relative;
            width: 100%;
            padding-right: 0.75rem;
            padding-left: 0.75rem;
        }
        
        .table-condensed {
            font-size: 0.75rem;
        }
        
        .table-condensed td {
            padding: 0.25rem;
        }
        
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: rgba(0, 0, 0, 0.05);
        }
        
        .table-responsive {
            display: block;
            width: 100%;
            overflow-x: auto;
        }
        
        .table-bordered {
            border: 1px solid #dee2e6;
        }
        
        .table-bordered td {
            border: 1px solid #dee2e6;
        }
        
        .text-center {
            text-align: center !important;
        }
        
        .d-flex {
            display: flex !important;
        }
        
        .align-items-center {
            align-items: center !important;
        }
        
        .justify-content-center {
            justify-content: center !important;
        }
        
        .justify-content-between {
            justify-content: space-between !important;
        }
        
        .gap-3 {
            gap: 1rem !important;
        }
        
        .mt-2 {
            margin-top: 0.5rem !important;
        }
        
        .mt-3 {
            margin-top: 1rem !important;
        }
        
        .mb-0 {
            margin-bottom: 0 !important;
        }
        
        .mb-1 {
            margin-bottom: 0.25rem !important;
        }
        
        .p-2 {
            padding: 0.5rem !important;
        }
        
        .px-2 {
            padding-left: 0.5rem !important;
            padding-right: 0.5rem !important;
        }
        
        .report-title {
            font-size: 16px;
            font-style: italic;
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            height: 35px;
            padding-top: 8px;
            margin-top: 0px;
            background-color: #757575 !important;
            color: white;
        }

        .add-border {
            border: 1px solid #CCC;
        }

        .school-logo {
            width: auto;
            height: 80px;
            border-radius: 5px;
            flex-shrink: 0;
        }

        .school-info {
            text-align: center;
        }

        .student-photo {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 5px;
            flex-shrink: 0;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
            border: 2px solid #333;
            margin: 10px;
        }

        .result-header {
            font-size: 8px;
            background-color: #757575 !important;
            color: white;
        }

        .fontwhite {
            color: #FFF !important;
        }

        .result-body {
            font-size: 9px;
            font-weight: bolder;
        }

        .result-body2 {
            font-size: 8px;
            font-weight: normal;
        }

        .result-body3 {
            font-size: 7px;
            font-weight: normal;
        }

        .report-body2 {
            font-size: 9px;
            font-weight: bold;
        }

        .fontnormal {
            font-weight: normal;
        }

        .school-name {
            font-size: 18px;
            font-family: Georgia, "Times New Roman", Times, serif;
            font-weight: bolder;
            margin-bottom: 5px;
        }

        .contacts {
            font-size: 10px;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .bgimage {
            background-image: url(images/signin_feild_bg.gif) !important;
            background-repeat: repeat;
            -webkit-print-color-adjust: exact;
        }

        .qr-code {
            width: 120px;
            height: 120px;
            margin-top: 10px;
        }
        
        table {
            border-collapse: collapse;
        }
    </style>
</head>
<body>
<div style="width:99%;margin:auto;margin-top:0px;padding:8px;margin-bottom:15px" class="bgimage add-border main-container">

    <!-- START OF BANNER DIV -->
    <div class="header-flex">
        <img src="{{ public_path('images/rosa-mys-logo.png') }}" alt="school logo" class="school-logo">
        <div class="school-info">
            <div class="school-name">{{ config('app.name') }}</div>
            <div class="contacts">Road 2 house 14 ,Beverly Hills Trans-Nkisi, G.R.A . Onitsha Anambra State.</div>
            <div class="contacts">rosamysticaschool.org | Info@rosamysticaschool.org</div>
            <div class="contacts">Phone: 09012628700 , 08034726594</div>
        </div>
    </div>
    <!-- END OF BANNER DIV -->

    <!-- START OF REPORT TITLE DIV -->
    <div class="text-center report-title fontwhite" style="margin-top: 8px;">
        Termly Report
    </div>
    <!-- END OF REPORT TITLE DIV -->

    <!-- START OF DESCRIPTION SECTION DIV -->
    <div class="student-section">
        <div class="student-details">
            <table class="table-condensed report-body2">
                <tbody>
                <tr>
                    <td><strong>Student ID:</strong> <span class="fontnormal">{{ $data['student']->student_id ?? 'N/A' }}</span></td>
                </tr>
                <tr>
                    <td><strong>Name:</strong> <span class="fontnormal">{{ $data['student']->name }}</span></td>
                </tr>
                <tr>
                    <td>
                        <strong>Academic Session:</strong> <span class="fontnormal">{{ $data['session']->start_year }}/{{ $data['session']->end_year }}</span>
                        &nbsp; <strong>Term:</strong> <span class="fontnormal">{{ $data['session']->name }}</span>
                    </td>
                </tr>
                <tr>
                    <td><strong>Next Term Begins:</strong> <span class="fontnormal">{{ $data['session']->next_session_start_date ? $data['session']->next_session_start_date->format('M jS, Y') : 'TBA' }}</span></td>
                </tr>
                <tr>
                    <td>
                        <strong>Gender:</strong> <span class="fontnormal">{{ ucfirst($data['student']->gender ?? 'N/A') }}</span>&nbsp;
                        <strong>Class:</strong> <span class="fontnormal">{{ $data['class']->display_name }}</span>&nbsp;
                        <strong>Remarks:</strong> <span style="color: {{ $data['studentData']['remark'] === 'Pass' ? 'green' : 'red' }}">{{ $data['studentData']['remark'] }}</span>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
        <img src="{{ public_path($data['student']->profile_photo ? 'storage/' . $data['student']->profile_photo : 'images/user-avatar.png') }}" alt="photo" class="student-photo">
    </div>
    <!-- END OF DESCRIPTION SECTION DIV -->

    <!-- START OF result SECTION DIV -->
    <div class="row">
        <div class="col-xs-12">
            <table width="99%" border="0" align="left" class="table-condensed table-responsive">
                <tbody>
                <tr>
                    <td align="left" valign="top">
                        <table width="100%" class="table-condensed table-striped table-responsive table-bordered"
                               border="1">
                            <thead>
                            <tr class="result-header">
                                <td align="center" width="20%" class="fontwhite">Subject</td>
                                <td align="center" class="fontwhite">CA <br>(40%)</td>
                                <td align="center" class="fontwhite">Exam <br>(60%)</td>
                                <td align="center" class="fontwhite">Total <br> Score <br>(100%)</td>
                                <td align="center" class="fontwhite">Grade</td>
                                <td align="center" class="fontwhite" width="10%">Remarks</td>
                            </tr>
                            </thead>
                            <tbody class="result-body">
                            @foreach($data['subjects'] as $subject)
                                @php
                                    $subjectResult = $data['studentData']['subjects'][$subject->id] ?? null;
                                    $caScore = $subjectResult['ca_score'] ?? 0;
                                    $examScore = $subjectResult['exam_score'] ?? 0;
                                    $caAbsent = $subjectResult['ca_absent'] ?? false;
                                    $examAbsent = $subjectResult['exam_absent'] ?? false;
                                    $total = intval($subjectResult['total'] ?? 0);
                                    $grade = $subjectResult['grade'] ?? 'F';
                                    $remark = $total >= 70 ? 'Excellent' : ($total >= 60 ? 'Very Good' : ($total >= 50 ? 'Good' : ($total >= 45 ? 'Average' : ($total >= 40 ? 'Poor' : 'Fail'))));
                                @endphp
                                <tr>
                                    <td nowrap="nowrap">{{ strtoupper($subject->display_name) }}</td>
                                    <td>{{ $caAbsent ? 'Absent' : intval($caScore) }}</td>
                                    <td>{{ $examAbsent ? 'Absent' : intval($examScore) }}</td>
                                    <td>{{ $total }}</td>
                                    <td>{{ $grade }}</td>
                                    <td>{{ $remark }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </td>

                    @if($data['approval'])
                        <td align="left" valign="top" style="padding-left:5px;padding-right:5px">
                            <table width="98%" class="table-condensed table-striped table-responsive table-bordered"
                                   border="1">
                                <thead></thead>
                                <tbody class="result-body3">
                                <tr class="result-header">
                                    <td width="" height="20" align="center" class="fontwhite" nowrap="nowrap">AFFECTIVE
                                        TRAITS
                                    </td>
                                    <td width="39">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Punctuality</td>
                                    <td align="center" class="">{{ intval($data['approval']->punctuality) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Mental Alertness</td>
                                    <td align="center">{{ intval($data['approval']->mental_alertness) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Attentiveness</td>
                                    <td align="center">{{ intval($data['approval']->attentiveness) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Respect</td>
                                    <td align="center">{{ intval($data['approval']->respect) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Neatness</td>
                                    <td align="center">{{ intval($data['approval']->neatness) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Politeness</td>
                                    <td align="center">{{ intval($data['approval']->politeness) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Honesty</td>
                                    <td align="center">{{ intval($data['approval']->honesty) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Relationship with Peers</td>
                                    <td align="center">{{ intval($data['approval']->relationship_with_peers) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Attitude To School</td>
                                    <td align="center">{{ intval($data['approval']->attitude_to_school) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Spirit of Team Work</td>
                                    <td align="center">{{ intval($data['approval']->teamwork) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Completes School Work Promptly</td>
                                    <td align="center">{{ intval($data['approval']->completes_school_work_promptly) }}</td>
                                </tr>
                                <tr class="result-header">
                                    <td height="20" nowrap="nowrap" class="fontwhite" align="center">&nbsp;&nbsp;&nbsp;PSYCHOMOTOR
                                        SKILLS
                                    </td>
                                    <td align="center">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Reading</td>
                                    <td align="center">{{ intval($data['approval']->reading) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Verbal Fluency / Diction</td>
                                    <td align="center">{{ intval($data['approval']->verbal_fluency_diction) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Handwriting</td>
                                    <td align="center">{{ intval($data['approval']->handwriting) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Musical Skills</td>
                                    <td align="center">{{ intval($data['approval']->musical_skills) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Creative Arts</td>
                                    <td align="center">{{ intval($data['approval']->creative_arts) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Physical Education</td>
                                    <td align="center">{{ intval($data['approval']->physical_education) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap">&nbsp;&nbsp;&nbsp;General Reasoning</td>
                                    <td align="center">{{ intval($data['approval']->general_reasoning) }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    @endif
                </tr>
                </tbody>
            </table>
        </div>
    </div>
    <!-- END OF result SECTION DIV -->

    <!-- START OF report summary SECTION DIV -->
    <div style="display: flex; gap: 10px; margin-top: 10px;">
        <div style="flex: 2;">
            <table width="100%" class="table-condensed table-striped table-responsive table-bordered" border="1">
                <thead>
                <tr class="result-header">
                    <td colspan="2" align="center" class="fontwhite">Report Summary</td>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td width="60%" nowrap="nowrap" class="result-body"><strong>Overall Total Score</strong></td>
                    <td width="40%" class="result-body2">{{ intval($data['studentData']['grand_total']) }} out of {{ count($data['subjects']) * 100 }}</td>
                </tr>
                <tr>
                    <td nowrap="nowrap" class="result-body"><strong>Average Score</strong></td>
                    <td class="result-body2">{{ $data['studentData']['average'] }}</td>
                </tr>
                <tr>
                    <td nowrap="nowrap" class="result-body"><strong>Total Subjects Offered</strong></td>
                    <td class="result-body2">{{ count($data['subjects']) }}</td>
                </tr>
                @if($data['approval'])
                    <tr>
                        <td nowrap="nowrap" class="result-body"><strong>Head Teacher's Comment</strong></td>
                        <td class="result-body2">{{ $data['approval']->principal_remarks }}</td>
                    </tr>
                @endif
                </tbody>
            </table>
            @if($qrCode)
                <div class="qr-code" style="text-align: center;">
                    {!! $qrCode !!}
                </div>
            @endif
        </div>

        <div style="flex: 2;">
            <table width="100%" class="table-condensed table-striped table-responsive table-bordered" border="1">
                <thead>
                <tr class="result-header">
                    <td colspan="2" align="center" class="fontwhite">Grading System</td>
                </tr>
                </thead>
                <tbody class="result-body">
                <tr>
                    <td width="50%" nowrap="nowrap"><strong>{{ $data['session']->grade_a_min }}% - 100%</strong></td>
                    <td width="50%" class="result-body2">A - Excellent</td>
                </tr>
                <tr>
                    <td nowrap="nowrap"><strong>{{ $data['session']->grade_b_min }}% - {{ $data['session']->grade_a_min - 1 }}%</strong></td>
                    <td class="result-body2">B - Very Good</td>
                </tr>
                <tr>
                    <td nowrap="nowrap"><strong>{{ $data['session']->grade_c_min }}% - {{ $data['session']->grade_b_min - 1 }}%</strong></td>
                    <td class="result-body2">C - Good</td>
                </tr>
                <tr>
                    <td nowrap="nowrap"><strong>{{ $data['session']->grade_d_min }}% - {{ $data['session']->grade_c_min - 1 }}%</strong></td>
                    <td class="result-body2">D - Average</td>
                </tr>
                <tr>
                    <td nowrap="nowrap"><strong>{{ $data['session']->grade_e_min }}% - {{ $data['session']->grade_d_min - 1 }}%</strong></td>
                    <td class="result-body2">E - Poor</td>
                </tr>
                <tr>
                    <td><strong>0% - {{ $data['session']->grade_e_min - 1 }}%</strong></td>
                    <td class="result-body2">F - Fail</td>
                </tr>
                <tr class="result-header">
                    <td colspan="2" class="result-body fontwhite" style="text-align: center;">
                        CA: Continuous Assessment<br>
                        Avg = Total ÷ Subjects
                    </td>
                </tr>
                </tbody>
            </table>
        </div>

        <div style="flex: 1;">
            @php
                $signatureType = settings('signature_type', 'head_teacher');
                $showProprietor = settings('show_proprietor_signature', false);
                $showHeadTeacher = settings('show_head_teacher_signature', true);
                $proprietorName = settings('proprietor_name', 'School Proprietor');
                $headTeacherName = settings('head_teacher_name', 'Head Teacher');
            @endphp
            @if($signatureType === 'both')
                <div style="display: flex; gap: 10px;">
                    @if($showProprietor)
                    <table width="50%" class="table-condensed table-responsive">
                        <tbody class="result-body">
                        <tr>
                            <td align="center">
                                <img src="{{ public_path('images/proprietor-sign.jpg') }}" style="width:80px;height:50px;border-radius:5px" alt="proprietor stamp" class="img-responsive">
                            </td>
                        </tr>
                        <tr>
                            <td align="center" class="fontwhite result-header">{{ $proprietorName }}</td>
                        </tr>
                        <tr>
                            <td align="center" class="fontwhite result-header">Proprietor</td>
                        </tr>
                        <tr>
                            <td align="center" class="fontwhite result-header">{{ config('app.name') }}</td>
                        </tr>
                        </tbody>
                    </table>
                    @endif
                    @if($showHeadTeacher)
                    <table width="50%" class="table-condensed table-responsive">
                        <tbody class="result-body">
                        <tr>
                            <td align="center">
                                <img src="{{ public_path('images/head-teacher-sign.jpg') }}" style="width:80px;height:50px;border-radius:5px" alt="head teacher stamp" class="img-responsive">
                            </td>
                        </tr>
                        <tr>
                            <td align="center" class="fontwhite result-header">{{ $headTeacherName }}</td>
                        </tr>
                        <tr>
                            <td align="center" class="fontwhite result-header">Head Teacher</td>
                        </tr>
                        <tr>
                            <td align="center" class="fontwhite result-header">{{ config('app.name') }}</td>
                        </tr>
                        </tbody>
                    </table>
                    @endif
                </div>
            @elseif($signatureType === 'proprietor' && $showProprietor)
                <table width="100%" class="table-condensed table-responsive">
                    <tbody class="result-body">
                    <tr>
                        <td align="center">
                            <img src="{{ public_path('images/proprietor-sign.jpg') }}" style="width:100px;height:60px;border-radius:5px" alt="proprietor stamp" class="img-responsive">
                        </td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">{{ $proprietorName }}</td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">Proprietor</td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">{{ config('app.name') }}</td>
                    </tr>
                    </tbody>
                </table>
            @elseif($signatureType === 'head_teacher' && $showHeadTeacher)
                <table width="100%" class="table-condensed table-responsive">
                    <tbody class="result-body">
                    <tr>
                        <td align="center">
                            <img src="{{ public_path('images/head-teacher-sign.jpg') }}" style="width:100px;height:60px;border-radius:5px" alt="head teacher stamp" class="img-responsive">
                        </td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">{{ $headTeacherName }}</td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">Head Teacher</td>
                    </tr>
                    <tr>
                        <td align="center" class="fontwhite result-header">{{ config('app.name') }}</td>
                    </tr>
                    </tbody>
                </table>
            @endif
        </div>
    </div>
    <!-- END OF report summary SECTION DIV -->

    <!-- Teachers and Timestamp Section -->
    @if(settings('show_class_teachers_on_print', true) || settings('show_timestamp', true))
    <div style="margin-top: 15px; border-top: 1px solid #ccc; padding-top: 8px;">
        <div style="display: flex; justify-content: space-between; align-items: center; font-size: 8px;">
            @if(settings('show_class_teachers_on_print', true))
            <div>
                <strong>Class Teachers:</strong>
                <span>
                    @if(isset($data['teachers']) && $data['teachers']->count() > 0)
                        {{ $data['teachers']->pluck('name')->join(', ') }}
                    @else
                        No teachers assigned
                    @endif
                </span>
            </div>
            @endif
            @if(settings('show_timestamp', true))
            <div>
                <span>Generated on: {{ now()->format('M d, Y \\a\\t h:i A') }}</span>
            </div>
            @endif
        </div>
    </div>
    @endif
</div>
</body>
</html>