@extends('layouts.school-portal')

@section('title', 'School Sessions')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2 class="">School Sessions</h2>
                    <a href="{{ route('school-sessions.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Add New Session
                    </a>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <div class="card">
                    <div class="card-body">
                        <livewire:school-sessions-table/>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
