@extends('layouts.school-portal')

@section('title', 'My Profile')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">My Profile</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-4">
            <div class="card mb-3">
                <div class="card-body text-center">
                    <div class="mb-3">
                        @if($staff->profile_photo)
                            <img src="{{ asset('storage/' . $staff->profile_photo) }}" 
                                 alt="Profile Photo" class="rounded-circle" width="120" height="120">
                        @else
                            <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" 
                                 style="width: 120px; height: 120px;">
                                <span class="text-white fs-1">{{ $staff->initials() }}</span>
                            </div>
                        @endif
                    </div>
                    <h5 class="mb-1">{{ $staff->name }}</h5>
                    <p class="text-muted">{{ $staff->username }}</p>
                    <p class="text-muted">
                        @foreach($staff->roles as $role)
                            <span class="badge bg-primary">{{ ucwords(str_replace('_', ' ', $role->name)) }}</span>
                        @endforeach
                    </p>
                </div>
            </div>

            @if($staff->hasAnyRole(['admin', 'bursar', 'head_teacher']))
            <div class="card mb-3">
                <div class="card-header">
                    <h4 class="card-title mb-0">Change Password</h4>
                </div>
                <div class="card-body">
                    @livewire('staff.change-password-form')
                </div>
            </div>
            @endif
        </div>

        <div class="col-lg-8">
            <div class="card mb-3">
                <div class="card-header">
                    <h4 class="card-title mb-0">Personal Information</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">First Name</label>
                            <p>{{ $staff->firstname }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Middle Name</label>
                            <p>{{ $staff->middlename ?: 'N/A' }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Surname</label>
                            <p>{{ $staff->surname }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Gender</label>
                            <p>{{ ucfirst($staff->gender) }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Date of Birth</label>
                            <p>{{ $staff->dob ? \Carbon\Carbon::parse($staff->dob)->format('M d, Y') : 'N/A' }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Marital Status</label>
                            <p>{{ $staff->marital_status ? ucfirst($staff->marital_status) : 'N/A' }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Email</label>
                            <p>{{ $staff->email ?: 'N/A' }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Phone</label>
                            <p>{{ $staff->phone ?: 'N/A' }}</p>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label fw-bold">Address</label>
                            <p>{{ $staff->address ?: 'N/A' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            @if($staff->isTeacher())
            <div class="card mb-3">
                <div class="card-header">
                    <h4 class="card-title mb-0">Assigned Classes</h4>
                </div>
                <div class="card-body">
                    @if($staff->classes->count() > 0)
                        <div class="row">
                            @foreach($staff->classes as $class)
                                <div class="col-md-6 mb-2">
                                    <span class="badge bg-info">{{ $class->name }}</span>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted">No classes assigned yet.</p>
                    @endif
                </div>
            </div>
            @endif

            @if($staff->monthly_salary)
            <div class="card mb-3">
                <div class="card-header">
                    <h4 class="card-title mb-0">Payroll Information</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        @if(\App\Models\Setting::get('allow_staff_salary_view', true))
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Monthly Salary</label>
                            <p>₦{{ number_format($staff->monthly_salary, 2) }}</p>
                        </div>
                        @endif
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Payment Day</label>
                            <p>{{ $staff->payment_day ? ordinal($staff->payment_day) . ' of each month' : 'Last day of month' }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Bank Name</label>
                            <p>{{ $staff->bank_name ?: 'N/A' }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Account Number</label>
                            <p>{{ $staff->account_number ?: 'N/A' }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Account Name</label>
                            <p>{{ $staff->account_name ?: 'N/A' }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Tax ID</label>
                            <p>{{ $staff->tax_id ?: 'N/A' }}</p>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

@php
function ordinal($number) {
    $ends = ['th','st','nd','rd','th','th','th','th','th','th'];
    if ((($number % 100) >= 11) && (($number % 100) <= 13))
        return $number. 'th';
    else
        return $number. $ends[$number % 10];
}
@endphp
@endsection
