@extends('layouts.school-portal')

@section('title', 'Student Dashboard')

@section('content')
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="welcome-card dashboard-welcome mb-4">
                    <h1 class="welcome-title text-light">Welcome Back!</h1>
                    <p class="welcome-subtitle text-light">{{ $student->name }}</p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <livewire:dashboard-announcements/>
            </div>
        </div>

        <div class="row my-3">
            <div class="col-xl-3 col-md-6 mb-3">
                <div class="dashboard-card">
                    <div class="card-icon classes">
                        <i class="fas fa-school"></i>
                    </div>
                    <div class="card-content">
                        <h3>My Class</h3>
                        <p class="card-number">{{ $student->batch->schoolClass->display_name ?? 'Not Assigned' }}</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-3">
                <div class="dashboard-card">
                    <div class="card-icon pending">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div class="card-content">
                        <h3>Pending Payments</h3>
                        <p class="card-number">{{ $student->paymentRequests()->whereIn('status', ['unpaid', 'processing', 'partial_payment'])->count() }}</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-3">
                <div class="dashboard-card">
                    <div class="card-icon payments">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <div class="card-content">
                        <h3>Current Session</h3>
                        <p class="card-number">{{ $currentSession->name ?? 'No Active Session' }}</p>
                        @if($currentSession)
                            <small class="text-muted">{{ $currentSession->start_year }}
                                /{{ $currentSession->end_year }}</small>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-3">
                <div class="dashboard-card">
                    <div class="card-icon student">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="card-content">
                        <h3>Approved Results</h3>
                        <p class="card-number">{{ $student->resultApprovals()->count() + $student->annualResultApprovals()->count() }}</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8">
                <!-- Additional content can go here -->
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Quick Actions</h4>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('student.results.termly') }}" class="btn btn-primary">
                                <i class="fas fa-chart-line me-2"></i>View Termly Results
                            </a>
                            <a href="{{ route('student.results.annual') }}" class="btn btn-info">
                                <i class="fas fa-calendar-alt me-2"></i>View Annual Results
                            </a>
                            <a href="{{ route('student.payments.index') }}" class="btn btn-warning">
                                <i class="fas fa-money-bill-wave me-2"></i>Payment History
                            </a>
                            <a href="{{ route('student.profile') }}" class="btn btn-secondary">
                                <i class="fas fa-user me-2"></i>My Profile
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
