<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Receipt - {{ $payment->payment_id }}</title>
    <link href="{{ asset('vendor/bootstrap-5.3.7.min.css') }}" rel="stylesheet">
    <link href="{{ asset('vendor/fontawesome-6.7.2/css/all.min.css') }}" rel="stylesheet">
    <style>
        @page {
            size: A4;
            margin: 0.75in;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12pt;
            line-height: 1.4;
            position: relative;
        }
        
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: repeating-linear-gradient(
                45deg,
                transparent,
                transparent 35px,
                rgba(0,0,0,0.02) 35px,
                rgba(0,0,0,0.02) 70px
            );
            background-size: 100px 100px;
            z-index: -1;
            pointer-events: none;
        }
        
        body::after {
            content: '{{ $schoolInfo['name'] }} {{ $schoolInfo['name'] }} {{ $schoolInfo['name'] }} {{ $schoolInfo['name'] }} {{ $schoolInfo['name'] }} {{ $schoolInfo['name'] }} {{ $schoolInfo['name'] }} {{ $schoolInfo['name'] }} {{ $schoolInfo['name'] }} {{ $schoolInfo['name'] }}';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            font-size: 8px;
            color: rgba(0,0,0,0.03);
            word-wrap: break-word;
            overflow: hidden;
            z-index: -1;
            pointer-events: none;
            line-height: 20px;
            letter-spacing: 10px;
        }

        .header-flex {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
            margin-bottom: 20px;
        }

        .school-logo {
            width: auto;
            height: 80px;
            border-radius: 5px;
            flex-shrink: 0;
        }

        .school-info {
            text-align: center;
        }

        .school-name {
            font-size: 24px;
            font-family: Georgia, "Times New Roman", Times, serif;
            font-weight: bolder;
            margin-bottom: 5px;
        }

        .contacts {
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .report-title {
            font-size: 20px;
            font-style: italic;
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            height: 40px;
            padding-top: 10px;
            margin: 20px 0;
            background-color: #757575 !important;
            text-align: center;
            border-bottom: 4px solid #333;
        }
        
        .paid-stamp {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 48px;
            font-weight: bold;
            color: #28a745;
            transform: rotate(-15deg);
            border: 4px solid #28a745;
            padding: 10px 20px;
            border-radius: 10px;
            background-color: rgba(40, 167, 69, 0.1);
        }

        .fontwhite {
            color: #FFF !important;
        }

        .student-section {
            display: flex;
            align-items: flex-start;
            justify-content: space-between;
            gap: 30px;
            margin-bottom: 20px;
        }
        
        .student-details {
            flex: 1;
        }
        
        .receipt-details {
            flex: 1;
        }

        .student-photo {
            width: 150px;
            height: 150px;
            object-fit: cover;
            border-radius: 5px;
            flex-shrink: 0;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
            border: 2px solid #333;
        }

        .student-details {
            flex-grow: 1;
        }

        .receipt-details {
            margin-bottom: 20px;
        }

        .payment-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }

        .payment-table th,
        .payment-table td {
            border: 1px solid #333;
            padding: 8px;
            text-align: left;
        }

        .payment-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }

        .total-row {
            background-color: #d4edda;
            font-weight: bold;
        }

        .notes-section {
            margin: 20px 0;
            padding: 10px;
            background-color: #f8f9fa;
            border-left: 4px solid #007bff;
        }

        .footer-section {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            margin-top: 40px;
        }
        
        .qr-code {
            width: 150px;
            height: 150px;
        }
        
        .footer-text {
            text-align: center;
            flex-grow: 1;
            font-size: 10px;
            color: #666;
        }

        .receipt-content {
            padding: 20px;
        }
        
        @media print {
            body {
                margin: 0 !important;
                padding: 0 !important;
            }
            .receipt-content {
                padding: 15px !important;
            }
            .no-print {
                display: none !important;
            }
        }
        
        .no-print {
            margin-top: 20px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="receipt-content" style="padding: 20px;">
        <!-- School Header -->
        <div class="header-flex">
            <img src="{{ asset('images/rosa-mys-logo.png') }}" alt="school logo" class="school-logo">
            <div class="school-info">
                <div class="school-name">{{ $schoolInfo['name'] }}</div>
                @if($schoolInfo['address'])
                    <div class="contacts">{{ $schoolInfo['address'] }}</div>
                @endif
                <div class="contacts">
                    @if($schoolInfo['website'])
                        <i class="fa fa-desktop"></i> {{ $schoolInfo['website'] }}
                    @endif
                    @if($schoolInfo['email'])
                        @if($schoolInfo['website']) | @endif
                        <i class="fa fa-envelope"></i> {{ $schoolInfo['email'] }}
                    @endif
                </div>
                @if($schoolInfo['phone'])
                    <div class="contacts"><i class="fa fa-phone"></i> Phone: {{ $schoolInfo['phone'] }}</div>
                @endif
            </div>
        </div>

        <!-- Receipt Title -->
        <div class="report-title fontwhite">
            Payment Receipt
        </div>

        <!-- Student and Receipt Information -->
        <div class="student-section">
            <div class="student-details">
                <h6><strong>Student Information</strong></h6>
                <p><strong>Name:</strong> {{ $payment->user->name }}</p>
                <p><strong>Student ID:</strong> {{ $payment->user->student_id ?? $payment->user->username }}</p>
                <p><strong>Class:</strong> {{ $payment->user->schoolClass->name ?? 'N/A' }}</p>
            </div>
            <div class="receipt-details">
                <h6><strong>Receipt Details</strong></h6>
                <p><strong>Receipt ID:</strong> {{ $payment->payment_id }}</p>
                <p><strong>Date:</strong> {{ $payment->updated_at->format('M d, Y g:i A') }}</p>
                <p><strong>Status:</strong> Paid</p>
                <p><strong>Confirmed By:</strong> {{ $payment->recordedBy->name ?? 'System' }}</p>
            </div>
            <img src="{{ $payment->user->profile_photo ? asset('storage/' . $payment->user->profile_photo) : asset('images/user-avatar.png') }}" 
                 alt="student photo" class="student-photo">
        </div>

        <!-- Payment Information -->
        <h6><strong>Payment Information</strong></h6>
        <table class="payment-table">
            <thead>
                <tr>
                    <th>Description</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $payment->paymentRequest?->title ?? 'Direct Payment' }}</td>
                    <td>{{ $payment->currency_symbol }}{{ number_format($payment->amount) }}</td>
                </tr>
            </tbody>
            <tfoot>
                <tr class="total-row">
                    <th>Total Paid</th>
                    <th>{{ $payment->currency_symbol }}{{ number_format($payment->amount) }}</th>
                </tr>
            </tfoot>
        </table>

        @if($payment->notes)
            <div class="notes-section">
                <h6><strong>Notes</strong></h6>
                <p>{{ $payment->notes }}</p>
            </div>
        @endif

        <!-- Paid Stamp -->
        <div class="paid-stamp">PAID</div>
        
        <div class="footer-section">
            <div class="qr-code">
                {!! $qrCode !!}
            </div>
            <div class="footer-text">
                <p>This is an official receipt for your payment.<br>
                Thank you for your payment!</p>
                <p>Generated on: {{ now()->format('M d, Y \a\t h:i A') }}</p>
            </div>
        </div>
    </div>

    <div class="no-print">
        <button class="btn btn-primary" onclick="window.print()">
            <i class="fa fa-print"></i> Print Receipt
        </button>
        <button class="btn btn-secondary" onclick="window.close()">
            <i class="fa fa-times"></i> Close
        </button>
    </div>

    <script>
        window.addEventListener('load', function() {
            setTimeout(function() {
                window.print();
            }, 500);
        });
    </script>
</body>
</html>