@extends('layouts.school-portal')

@section('title', 'Payment Receipt')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">Payment Receipt</h4>
                    <button onclick="window.open('{{ route('student.payments.receipt.print', $payment->payment_id) }}', '_blank', 'width=800,height=600')" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-print me-1"></i>Print
                    </button>
                </div>
                <div class="card-body">
                    <div class="receipt-content">
                        <div class="header-flex mb-4">
                            <img src="{{ asset('images/rosa-mys-logo.png') }}" alt="school logo" class="school-logo">
                            <div class="school-info">
                                <div class="school-name">{{ $schoolInfo['name'] }}</div>
                                @if($schoolInfo['address'])
                                    <div class="contacts">{{ $schoolInfo['address'] }}</div>
                                @endif
                                <div class="contacts">
                                    @if($schoolInfo['website'])
                                        <i class="fa fa-desktop"></i> {{ $schoolInfo['website'] }}
                                    @endif
                                    @if($schoolInfo['email'])
                                        @if($schoolInfo['website']) | @endif
                                        <i class="fa fa-envelope"></i> {{ $schoolInfo['email'] }}
                                    @endif
                                </div>
                                @if($schoolInfo['phone'])
                                    <div class="contacts"><i class="fa fa-phone"></i> Phone: {{ $schoolInfo['phone'] }}</div>
                                @endif
                            </div>
                        </div>
                        <div class="text-center report-title fontwhite mb-4">
                            Payment Receipt
                        </div>

                        <!-- Paid Stamp -->
                        <div class="paid-stamp">PAID</div>
                        
                        <!-- Student Information and Photo -->
                        <div class="student-info-section mb-4">
                            <div class="student-details">
                                <h6><strong>Student Information</strong></h6>
                                <p><strong>Name:</strong> {{ $payment->user->name }}</p>
                                <p><strong>Student ID:</strong> {{ $payment->user->student_id ?? $payment->user->username }}</p>
                                <p><strong>Class:</strong> {{ $payment->user->schoolClass->name ?? 'N/A' }}</p>
                            </div>
                            <img src="{{ $payment->user->profile_photo ? asset('storage/' . $payment->user->profile_photo) : asset('images/user-avatar.png') }}" 
                                 alt="student photo" class="student-photo">
                        </div>
                        
                        <!-- Receipt Details -->
                        <div class="receipt-details mb-4">
                            <h6><strong>Receipt Details</strong></h6>
                            <p><strong>Receipt ID:</strong> {{ $payment->payment_id }}</p>
                            <p><strong>Date:</strong> {{ $payment->updated_at->format('M d, Y g:i A') }}</p>
                            <p><strong>Status:</strong> <span class="badge bg-success">Paid</span></p>
                            <p><strong>Confirmed By:</strong> {{ $payment->recordedBy->name ?? 'System' }}</p>
                        </div>

                        <div class="mb-4">
                            <h6>Payment Information</h6>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Description</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>{{ $payment->paymentRequest?->title ?? 'Direct Payment' }}</td>
                                            <td>{{ $payment->currency_symbol }}{{ number_format($payment->amount) }}</td>
                                        </tr>
                                    </tbody>
                                    <tfoot>
                                        <tr class="table-success">
                                            <th>Total Paid</th>
                                            <th>{{ $payment->currency_symbol }}{{ number_format($payment->amount) }}</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>

                        @if($payment->notes)
                            <div class="mb-4">
                                <h6>Notes</h6>
                                <p class="text-muted">{{ $payment->notes }}</p>
                            </div>
                        @endif

                        <div class="footer-section mt-4">
                            <div class="qr-code">
                                {!! $qrCode !!}
                            </div>
                            <div class="footer-text">
                                <p class="text-muted small">
                                    This is an official receipt for your payment.<br>
                                    Thank you for your payment!
                                </p>
                                <p class="text-muted small">Generated on: {{ now()->format('M d, Y \a\t h:i A') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer text-center">
                    <a href="{{ route('student.payments.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i>Back to Payments
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.header-flex {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 15px;
}

.school-logo {
    width: auto;
    height: 80px;
    border-radius: 5px;
    flex-shrink: 0;
}

.school-info {
    text-align: center;
}

.school-name {
    font-size: 18px;
    font-family: Georgia, "Times New Roman", Times, serif;
    font-weight: bolder;
    margin-bottom: 5px;
}

.contacts {
    font-size: 10px;
    font-weight: bold;
    margin-bottom: 3px;
}

.report-title {
    font-size: 16px;
    font-style: italic;
    font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
    height: 35px;
    padding-top: 8px;
    margin-top: 0px;
    background-color: #757575 !important;
}

.fontwhite {
    color: #FFF !important;
}

.student-section {
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
    gap: 15px;
}

.student-info-section {
    display: flex;
    align-items: flex-start;
    gap: 10px;
    position: relative;
}

.student-details {
    flex: 1;
}

.receipt-details {
    width: 100%;
}

.student-photo {
    width: 150px;
    height: 150px;
    object-fit: cover;
    border-radius: 5px;
    flex-shrink: 0;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
    border: 2px solid #333;
}

.paid-stamp {
    position: absolute;
    top: 20px;
    left: 20px;
    font-size: 48px;
    font-weight: bold;
    color: #28a745;
    transform: rotate(-15deg);
    border: 4px solid #28a745;
    padding: 10px 20px;
    border-radius: 10px;
    background-color: rgba(40, 167, 69, 0.1);
    z-index: 10;
}

.footer-section {
    display: flex;
    justify-content: space-between;
    align-items: flex-end;
}

.qr-code {
    width: 150px;
    height: 150px;
}

.footer-text {
    flex-grow: 1;
    padding-left: 20px;
    text-align: center;
}

@media (max-width: 992px) {
    .footer-section {
        flex-direction: column;
        align-items: center;
        gap: 20px;
    }
    
    .footer-text {
        text-align: left;
        padding-left: 0;
    }
    
    .paid-stamp {
        position: relative;
        top: auto;
        left: auto;
        margin: 10px auto;
        transform: none;
    }
}

@media print {
    .card-header, .card-footer, .btn {
        display: none !important;
    }
    .card {
        border: none !important;
        box-shadow: none !important;
    }
    .receipt-content {
        padding: 0 !important;
    }
}
</style>
@endsection