<!DOCTYPE html>
<html>
<head>
    <title>Annual Result - {{ $data['student']->name }}</title>
    <link href="{{ asset('css/bootstrap.min.css') }}" rel="stylesheet">
    <style>
        .report-title {
            font-size: 20px;
            font-style: italic;
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            height: 50px;
            padding-top: 10px;
            margin-top: 0px;
            background-color: #757575 !important;
        }
        .add-border { border: 1px solid #CCC; }
        .padding10 { padding: 10px; }
        .margint10 { margin-top: 10px; }
        .margint5 { margin-top: 5px; }
        .photo {
            width: 100px;
            height: 100px;
            margin: auto;
            margin-bottom: 10px;
        }
        .result-header {
            font-size: 9px;
            background-color: #757575 !important;
        }
        .fontwhite { color: #FFF !important; }
        .result-body { font-size: 10px; font-weight: bolder; }
        .result-body2 { font-size: 9px; font-weight: normal; }
        .result-body3 { font-size: 8px; font-weight: normal; }
        .report-body { font-size: 9px; font-weight: bold; }
        .report-body2 { font-size: 10px; font-weight: bold; }
        .fontnormal { font-weight: normal; }
        .school-name {
            font-size: 20px;
            font-family: Georgia, "Times New Roman", Times, serif;
            font-weight: bolder;
        }
        .contacts { font-size: 11px; font-weight: bold; }
        .bgimage {
            background-image: url({{ asset('images/signin_feild_bg.gif') }});
            background-repeat: repeat;
            -webkit-print-color-adjust: exact;
        }
        @media print {
            .no-print { display: none !important; }
            body { font-size: 12px; }
        }
    </style>
</head>
<body style="margin:0px;padding:0px;background-color:#FFF;margin-bottom:20px;padding-bottom:20px">
    <div style="background-color:#FFF">
        <div class="container-fluid p-2 bgimage add-border">
            
            <!-- School Header -->
            <div class="row">
                <div class="col-xs-2">
                    @if($data['student']->photo)
                        <img src="{{ asset('storage/' . $data['student']->photo) }}" alt="school logo" width="100" class="img-responsive" style="height:100px;border-radius:5px">
                    @else
                        <div style="width:100px;height:100px;background:#ddd;border-radius:5px"></div>
                    @endif
                </div>
                <div class="col-xs-10">
                    <div class="row pull-right">
                        <div class="col-xs-12 school-name">{{ config('app.name') }}</div>
                    </div>
                    <div style="clear:both"></div>
                    <div class="row pull-right">
                        <div class="col-xs-12 contacts margint5">Road 2 house 14, Beverly Hills Trans-Nkisi, G.R.A. Onitsha Anambra State.</div>
                    </div>
                    <div style="clear:both"></div>
                    <div class="row pull-right">
                        <div class="col-xs-12 contacts margint5">rosamysticaschool.org | Info@rosamysticaschool.org</div>
                    </div>
                    <div style="clear:both"></div>
                    <div class="row pull-right">
                        <div class="col-xs-12 contacts margint5">Phone: 09012628700, 08034726594</div>
                    </div>
                    <div style="clear:both"></div>
                </div>
            </div>
            
            <!-- Report Title -->
            <div class="row">
                <div class="col-xs-12">
                    <div class="text-center report-title margint10 fontwhite">End of Year Report</div>
                </div>
            </div>
            
            <!-- Student Info -->
            <div class="row margint10">
                <div class="col-xs-12">
                    <div class="col-xs-10 padding0">
                        <table width="100%" class="table-condensed table-striped table-responsive report-body2">
                            <tbody>
                                <tr>
                                    <td><div class="row"><div class="col-xs-12"><strong>Student ID:</strong> <span class="fontnormal">{{ $data['student']->student_id }}</span></div></div></td>
                                </tr>
                                <tr>
                                    <td><div class="row"><div class="col-xs-12"><strong>Name:</strong> <span class="fontnormal">{{ $data['student']->name }}</span></div></div></td>
                                </tr>
                                <tr>
                                    <td><div class="row"><div class="col-xs-12"><strong>Academic Session:</strong> <span class="fontnormal">{{ $data['year'] }}/{{ $data['year'] + 1 }}</span> &nbsp; <strong>Term:</strong> <span class="fontnormal">Annual</span></div></div></td>
                                </tr>
                                <tr>
                                    <td><div class="row"><div class="col-xs-12"><strong>Gender:</strong> <span class="fontnormal">{{ $data['student']->gender ?? 'N/A' }}</span> &nbsp; <strong>Class:</strong> <span class="fontnormal">{{ $data['class']->name }}</span></div></div></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-xs-2">
                        @if($data['student']->photo)
                            <img src="{{ asset('storage/' . $data['student']->photo) }}" alt="photo" class="img-responsive photo" style="border-radius:5px">
                        @else
                            <div class="photo" style="background:#ddd;border-radius:5px"></div>
                        @endif
                    </div>
                </div>
            </div>
            
            <!-- Results Table -->
            <div class="row">
                <div class="col-xs-12">
                    <table width="99%" border="0" align="left" class="table-condensed table-responsive">
                        <tbody>
                            <tr>
                                <td align="left" valign="top">
                                <div class="table-responsive">
                                    <table class="table table-condensed table-striped table-bordered" style="min-width: 100%; font-size: 0.7rem;">
                                        <thead>
                                            <tr class="result-header">
                                                <td align="center" width="20%" class="fontwhite">Subject</td>
                                                @foreach($data['sessions'] as $session)
                                                    <td align="center" class="fontwhite">{{ $session->name }}<br>Summary<br>(100%)</td>
                                                @endforeach
                                                <td align="center" class="fontwhite">Total<br>Score</td>
                                                <td align="center" class="fontwhite">Average<br>Score<br>(100%)</td>
                                                <td align="center" class="fontwhite">Grade</td>
                                                <td align="center" class="fontwhite" width="10%">Remarks</td>
                                            </tr>
                                        </thead>
                                        <tbody class="result-body">
                                            @foreach($data['subjects'] as $subject)
                                                @php
                                                    $summary = app('App\Services\AnnualResultService')->calculateSubjectSummary($subject, $data['sessions'], $data['studentData']);
                                                @endphp
                                                <tr>
                                                    <td nowrap="nowrap">{{ strtoupper($subject->display_name) }}</td>
                                                    @foreach($data['sessions'] as $session)
                                                        @php
                                                            $sessionResult = $data['studentData']['sessions'][$session->id]['subjects'][$subject->id] ?? null;
                                                            $total = $sessionResult['total'] ?? 0;
                                                        @endphp
                                                        <td>{{ app('App\Services\AnnualResultService')->formatResultValue($total) }}</td>
                                                    @endforeach
                                                    <td>{{ $summary['total'] }}</td>
                                                    <td>{{ $summary['average'] }}</td>
                                                    <td>{{ $summary['grade'] }}</td>
                                                    <td>{{ $summary['remark'] }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                </td>
                                <td align="left" valign="top" style="padding-left:5px;padding-right:5px">
                                    <table width="98%" class="table-condensed table-striped table-responsive table-bordered" border="1">
                                        <tbody class="result-body3">
                                            <tr class="result-header">
                                                <td width="" height="20" align="center" class="fontwhite" nowrap="nowrap">AFFECTIVE TRAITS</td>
                                                <td width="39">&nbsp;</td>
                                            </tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Punctuality</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Mental Alertness</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Attentiveness</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Respect</td><td align="center">5</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Neatness</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Politeness</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Honesty</td><td align="center">5</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Relationship with Peers</td><td align="center">5</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Attitude To School</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Spirit of Team Work</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Completes School Work Promptly</td><td align="center">4</td></tr>
                                            <tr class="result-header">
                                                <td height="20" nowrap="nowrap" class="fontwhite" align="center">&nbsp;&nbsp;&nbsp;PSYCHOMOTOR SKILLS</td>
                                                <td align="center">&nbsp;</td>
                                            </tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Reading</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Verbal Fluency / Diction</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Handwriting</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Musical Skills</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Creative Arts</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;Physical Education</td><td align="center">4</td></tr>
                                            <tr><td nowrap="nowrap">&nbsp;&nbsp;&nbsp;General Reasoning</td><td align="center">4</td></tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <!-- Summary Section -->
            <div class="row margint10">
                <div class="col-xs-12">
                    <div class="col-xs-5" style="padding-left:0px">
                        <table width="100%" class="table-condensed table-striped table-responsive table-bordered" border="1">
                            <thead>
                                <tr class="result-header">
                                    <td colspan="2" align="center" class="fontwhite">Report Summary</td>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $helpers = app('App\Services\AnnualResultService')->getCalculationHelpers($data['sessions'], $data['subjects'], $data['studentData']);
                                    $annualMaxTotal = $helpers['annual_max_total'];
                                    $correctedAnnualAverage = $helpers['corrected_annual_average'];
                                    $promotionStatus = $helpers['promotion_status'];
                                @endphp
                                <tr>
                                    <td width="50%" nowrap="nowrap" class="result-body"><strong>Overall Total Score</strong></td>
                                    <td width="50%" class="result-body2">{{ $data['studentData']['annual_grand_total'] }} out of {{ $annualMaxTotal }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap" class="result-body"><strong>Annual Score %</strong></td>
                                    <td class="result-body2">{{ $correctedAnnualAverage }}%</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap" class="result-body"><strong>Total Subjects Offered</strong></td>
                                    <td class="result-body2">{{ count($data['subjects']) }}</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap" class="result-body"><strong>Teacher's Comment</strong></td>
                                    <td class="result-body2">Impressive result, keep it up!</td>
                                </tr>
                                <tr>
                                    <td nowrap="nowrap" class="result-body"><strong>Head Teacher's Comment</strong></td>
                                    <td class="result-body2">Impressive result, keep it up!</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="col-xs-4" style="padding-right:0px">
                        <table width="100%" class="table-condensed table-striped table-responsive table-bordered" border="1">
                            <thead>
                                <tr class="result-header">
                                    <td colspan="2" align="center" class="fontwhite">Grading System</td>
                                </tr>
                            </thead>
                            <tbody class="result-body">
                                <tr><td width="50%" nowrap="nowrap"><strong>70% - 100%</strong></td><td width="50%" class="result-body2">Excellent</td></tr>
                                <tr><td nowrap="nowrap"><strong>60% - 69%</strong></td><td class="result-body2">Very Good</td></tr>
                                <tr><td nowrap="nowrap"><strong>50% - 59%</strong></td><td class="result-body2">Good</td></tr>
                                <tr><td nowrap="nowrap"><strong>45% - 49%</strong></td><td class="result-body2">Average</td></tr>
                                <tr><td nowrap="nowrap"><strong>40% - 44%</strong></td><td class="result-body2">Poor</td></tr>
                                <tr><td><strong>0% - 39%</strong></td><td class="result-body2">Fail</td></tr>
                                <tr class="result-header">
                                    <td colspan="2" class="result-body fontwhite">CA: Continuous Assessment<br>Avg Score = Tot Score / No. Subj. Offered</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="col-xs-3">
                        <table width="100%" class="table-condensed table-responsive">
                            <tbody class="result-body">
                                <tr>
                                    <td width="50%" align="center" nowrap="nowrap">
                                        <br>
                                        <div style="width:150px;height:100px;background:#ddd;border-radius:5px;margin:auto"></div>
                                        <br>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center" nowrap="nowrap" class="fontwhite result-header">Head Teacher</td>
                                </tr>
                                <tr>
                                    <td align="center" nowrap="nowrap" class="fontwhite result-header">Signature & Stamp</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>