@extends('layouts.school-portal')

@section('title', 'Student Profile')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Student Profile</h1>
                <div class="d-flex flex-column flex-md-row gap-2">
                    <a href="{{ route('students.edit', $student_id) }}" class="btn btn-sm btn-md-normal btn-primary">
                        <i class="fas fa-edit me-2"></i>Edit Student
                    </a>
                    <a href="{{ route('students.index') }}" class="btn btn-sm btn-md-normal btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to Students
                    </a>
                </div>
            </div>
            
            @livewire('student-profile', ['studentId' => $student_id])
        </div>
    </div>
</div>
@endsection