<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-upload me-2"></i>
                        Offline Results Upload
                    </h4>
                </div>
                <div class="card-body">
                    <!--[if BLOCK]><![endif]--><?php if(!$uploadResults): ?>
                    <form wire:submit="uploadResults">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="selectedSession" class="form-label">Session</label>
                                <select wire:model.live="selectedSession" class="form-select" id="selectedSession">
                                    <option value="">Select Session</option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($session->id); ?>"><?php echo e($session->name); ?> (<?php echo e($session->start_year); ?>/<?php echo e($session->end_year); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedSession'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="selectedClass" class="form-label">Class</label>
                                <select wire:model.live="selectedClass" class="form-select" id="selectedClass">
                                    <option value="">Select Class</option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($class->id); ?>"><?php echo e($class->alias ?: $class->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedClass'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="selectedBatch" class="form-label">Batch</label>
                                <select wire:model.live="selectedBatch" class="form-select" id="selectedBatch">
                                    <option value="">Select Batch</option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($batch->id); ?>"><?php echo e($batch->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedBatch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="d-flex gap-2 flex-wrap">
                                    <button type="button" wire:click="downloadTemplate" 
                                            class="btn btn-outline-primary"
                                            <?php if(!$selectedClass || !$selectedBatch || !$selectedSession): ?> disabled <?php endif; ?>>
                                        <i class="fas fa-download me-2"></i>
                                        Download Template
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="uploadFile" class="form-label">Upload Excel File</label>
                                <input type="file" wire:model="uploadFile" class="form-control" id="uploadFile" 
                                       accept=".xlsx,.xls">
                                <div wire:loading wire:target="uploadFile" class="text-info mt-2">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Processing file...
                                </div>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['uploadFile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        
                        <!--[if BLOCK]><![endif]--><?php if($isUploading): ?>
                        <div class="row mb-3">
                            <div class="col-12">
                                <div class="progress">
                                    <div class="progress-bar progress-bar-striped progress-bar-animated" 
                                         role="progressbar" 
                                         style="width: <?php echo e($uploadProgress); ?>%"
                                         aria-valuenow="<?php echo e($uploadProgress); ?>" 
                                         aria-valuemin="0" 
                                         aria-valuemax="100">
                                        <?php echo e($uploadProgress); ?>%
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        
                        <div class="row">
                            <div class="col-12">
                                <button type="button" wire:click="processUpload" class="btn btn-primary" 
                                        wire:loading.attr="disabled" wire:target="uploadFile,processUpload"
                                        <?php if($isUploading || !$selectedClass || !$selectedBatch || !$selectedSession || !$uploadFile): ?> disabled <?php endif; ?>>
                                    <span wire:loading.remove wire:target="uploadFile,processUpload">
                                        <i class="fas fa-upload me-2"></i>
                                        <!--[if BLOCK]><![endif]--><?php if($isUploading): ?> Uploading... <?php else: ?> Upload Results <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                    <span wire:loading wire:target="uploadFile">
                                        <i class="fas fa-spinner fa-spin me-2"></i>Processing file...
                                    </span>
                                    <span wire:loading wire:target="processUpload">
                                        <i class="fas fa-spinner fa-spin me-2"></i>Uploading...
                                    </span>
                                </button>
                            </div>
                        </div>
                    </form>
                    <?php else: ?>
                    <!-- Upload Results Summary -->
                    <div class="alert alert-info">
                        <h5><i class="fas fa-info-circle me-2"></i>Upload Summary</h5>
                        <ul class="mb-0">
                            <li><strong><?php echo e($uploadResults['updated']); ?></strong> student results were updated</li>
                            <li><strong><?php echo e($uploadResults['ignored']); ?></strong> students were ignored (already approved results)</li>
                            <!--[if BLOCK]><![endif]--><?php if($uploadResults['wrong_class'] > 0): ?>
                                <li><strong><?php echo e($uploadResults['wrong_class']); ?></strong> students from wrong class/batch</li>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <!--[if BLOCK]><![endif]--><?php if(count($uploadResults['errors']) > 0): ?>
                                <li><strong><?php echo e(count($uploadResults['errors'])); ?></strong> errors occurred</li>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </ul>
                    </div>
                    
                    <!--[if BLOCK]><![endif]--><?php if(count($uploadResults['errors']) > 0): ?>
                    <div class="alert alert-warning">
                        <h6>Errors:</h6>
                        <ul class="mb-0">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $uploadResults['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </ul>
                    </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    
                    <button type="button" wire:click="resetUpload" class="btn btn-secondary">
                        <i class="fas fa-redo me-2"></i>
                        Upload Another File
                    </button>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/results/offline-upload.blade.php ENDPATH**/ ?>