<div>
    <div class="row g-3">
        <div class="col-lg-6 col-12">
            <div class="card">
                <div class="card-header">
                    <h5>Staff List</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <input type="text" wire:model.live="search" class="form-control" placeholder="Search staff...">
                    </div>

                    <!-- Mobile: Accordion view -->
                    <div class="d-lg-none">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="card mb-2">
                                <div class="card-body p-3">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1"><?php echo e($member->name); ?></h6>
                                            <div class="mb-2">
                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $member->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span
                                                        class="badge bg-secondary me-1"><?php echo e(ucfirst($role->display_name)); ?></span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                            <p class="mb-0 text-muted">
                                                ₦<?php echo e(number_format($member->monthly_salary ?? 0, 0)); ?></p>
                                        </div>
                                        <button wire:click="selectStaff(<?php echo e($member->id); ?>)"
                                                class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Desktop: Table view -->
                    <div class="d-none d-lg-block">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Role</th>
                                    <th>Salary</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($member->name); ?></td>
                                        <td>
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $member->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span
                                                    class="badge bg-secondary"><?php echo e(ucfirst($role->display_name)); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                        <td>₦<?php echo e(number_format($member->monthly_salary ?? 0, 0)); ?></td>
                                        <td>
                                            <button wire:click="selectStaff(<?php echo e($member->id); ?>)"
                                                    class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit me-2"></i>Edit
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <?php echo e($staff->links('custom.pagination')); ?>

                </div>
            </div>
        </div>

        <div class="col-lg-6 col-12">
            <!--[if BLOCK]><![endif]--><?php if($selectedStaff): ?>
                <div class="card">
                    <div class="card-header">
                        <h5>Edit Salary - <?php echo e($selectedStaff->name); ?></h5>
                    </div>
                    <div class="card-body">
                        <form wire:submit="updateSalary">
                            <div class="row g-2">
                                <div class="col-12">
                                    <label class="form-label">Monthly Salary *</label>
                                    <input type="number" wire:model="monthly_salary" class="form-control" step="1"
                                           required>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['monthly_salary'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Bank Name</label>
                                    <input type="text" wire:model="bank_name" class="form-control">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['bank_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-sm-6">
                                    <label class="form-label">Account Number</label>
                                    <input type="text" wire:model="account_number" class="form-control">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-sm-6">
                                    <label class="form-label">Account Name</label>
                                    <input type="text" wire:model="account_name" class="form-control">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['account_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-sm-6">
                                    <label class="form-label">Tax ID</label>
                                    <input type="text" wire:model="tax_id" class="form-control">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['tax_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-sm-6">
                                    <label class="form-label">Payment Day *</label>
                                    <input type="number" wire:model="payment_day" class="form-control" min="1" max="31"
                                           required>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['payment_day'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-12 mt-3">
                                    <button type="submit" class="btn btn-primary w-100">
                                        <i class="fas fa-save me-2"></i>Update Salary
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            <?php else: ?>
                <div class="card">
                    <div class="card-body text-center">
                        <i class="fas fa-user-plus fa-3x text-muted mb-3"></i>
                        <p class="text-muted">Select a staff member to edit their salary information</p>
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>
</div>
<?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/staff-salary-form.blade.php ENDPATH**/ ?>