<div>
    <!-- Filter Form -->
    <div class="row mb-4">
        <div class="col-md-3">
            <label for="year" class="form-label">Academic Year</label>
            <select wire:model="year" class="form-select" id="year">
                <option value="">Select Year</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $yearOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($yearOption); ?>"><?php echo e($yearOption); ?>/<?php echo e($yearOption + 1); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </select>
        </div>
        <div class="col-md-3">
            <label for="classId" class="form-label">Class</label>
            <select wire:model.live="classId" class="form-select" id="classId">
                <option value="">Select Class</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($class->id); ?>"><?php echo e($class->display_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </select>
        </div>
        <div class="col-md-3">
            <label for="batchId" class="form-label">Batch (Optional)</label>
            <select wire:model="batchId" class="form-select" id="batchId">
                <option value="">All Batches</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($batch->id); ?>"><?php echo e($batch->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">&nbsp;</label>
            <button wire:click="loadAnnualResults"
                    class="btn btn-primary w-100 d-flex align-items-center justify-content-center">
                <i class="fas fa-search me-2"></i>Load
            </button>
        </div>
    </div>

    <!--[if BLOCK]><![endif]--><?php if(!empty($annualData)): ?>
        <!-- Class Info Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card bg-light">
                    <div class="card-body">
                        <h5><?php echo e($selectedClass->display_name); ?><!--[if BLOCK]><![endif]--><?php if($selectedBatch): ?>
                                - <?php echo e($selectedBatch->name); ?>

                            <?php endif; ?><!--[if ENDBLOCK]><![endif]--></h5>
                        <p class="mb-1"><strong>Academic Year:</strong> <?php echo e($selectedYear); ?>/<?php echo e($selectedYear + 1); ?></p>
                        <p class="mb-0"><strong>Total Students:</strong> <?php echo e($classStats['total_students'] ?? 0); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chart and Summary Section -->
        <div class="row mb-4">
            <!-- Chart Column -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">Class Performance Chart</h6>
                    </div>
                    <div class="card-body">
                        <canvas id="classGradeChart" width="400" height="300" wire:ignore></canvas>
                    </div>
                </div>
            </div>

            <!-- Summary Column -->
            <div class="col-md-6">
                <!-- Class Summary Cards -->
                <div class="row mb-3">
                    <div class="col-6">
                        <div class="card text-center bg-primary">
                            <div class="card-body">
                                <h5 class="card-title text-white">Class Average</h5>
                                <h3 class="text-white"><?php echo e($classStats['class_average'] ?? 0); ?>%</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card text-center bg-success">
                            <div class="card-body">
                                <h5 class="card-title text-white">Passed</h5>
                                <h3 class="text-white"><?php echo e($classStats['passed_students'] ?? 0); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-6">
                        <div class="card text-center bg-info">
                            <div class="card-body">
                                <h5 class="card-title text-white">Sessions</h5>
                                <h3 class="text-white"><?php echo e($classStats['total_sessions'] ?? 0); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card text-center bg-danger">
                            <div class="card-body">
                                <h5 class="card-title text-white">Failed</h5>
                                <h3 class="text-white"><?php echo e($classStats['failed_students'] ?? 0); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Grade Distribution -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">Class Grade Distribution</h6>
                    </div>
                    <div class="card-body">
                        <div class="row text-center g-2">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = ['A', 'B', 'C', 'D', 'E', 'F']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-6 col-sm-4 col-md-2">
                                    <div
                                        class="badge bg-<?php echo e($grade === 'A' ? 'success' : ($grade === 'F' ? 'danger' : 'secondary')); ?> p-3 w-100 d-flex flex-column align-items-center justify-content-center"
                                        style="min-height: 60px;">
                                        <div class="fw-bold"><?php echo e($grade); ?></div>
                                        <div class="h6 mb-0"><?php echo e($classStats['grade_distribution'][$grade] ?? 0); ?></div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Student Results Table -->
        <div class="row">
            <div class="col-12">
                <div class="card border-0">
                    <div class="card-header border-0 p-2 mb-2 d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Student Annual Results</h6>
                        <button type="button" class="btn btn-outline-info btn-sm" data-bs-toggle="modal"
                                data-bs-target="#calculationHelpModal">
                            <i class="fas fa-question-circle"></i> Help
                        </button>
                    </div>
                    <div class="card-body p-0">
                        <!-- Desktop View -->
                        <div class="d-none d-lg-block">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped text-center align-middle">
                                    <thead class="table-dark">
                                    <tr>
                                        <th rowspan="2">Position</th>
                                        <th rowspan="2">Student Name</th>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <th colspan="2" class="text-center"><?php echo e($session->name); ?></th>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        <?php
                                            $maxAnnualScore = !empty($annualData) ? $annualData[0]['total_possible_score'] ?? 0 : 0;
                                        ?>
                                        <th rowspan="2">Annual Total (<?php echo e($maxAnnualScore); ?>)</th>
                                        <th rowspan="2">Total Average <!--[if BLOCK]><![endif]--><?php if(!empty($annualData)): ?>
                                                (<?php echo e(100 * count($subjects)); ?>)
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]--></th>
                                        <th rowspan="2">Annual Avg % (100%)</th>
                                        <th rowspan="2">Comment</th>
                                    </tr>
                                    <tr>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $maxSessionScore = !empty($annualData) ? $annualData[0]['sessions'][$session->id]['total_possible_score'] ?? 0 : 0;
                                            ?>
                                            <th>Total (<?php echo e($maxSessionScore); ?>)</th>
                                            <th>Average</th>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $annualData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $studentData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><strong><?php echo e($studentData['position_suffix'] ?? ($index + 1)); ?></strong>
                                            </td>
                                            <td class="text-start"><strong><?php echo e($studentData['student']->name); ?></strong>
                                            </td>
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $sessionData = $studentData['sessions'][$session->id] ?? null;
                                                ?>
                                                <td><?php echo e($sessionData['grand_total'] ?? 0); ?></td>
                                                <td><?php echo e($sessionData['average'] ?? 0); ?></td>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            <td><strong><?php echo e($studentData['annual_grand_total']); ?></strong></td>
                                            <td><strong><?php echo e($studentData['total_average']); ?></strong></td>
                                            <td><strong><?php echo e($studentData['annual_average']); ?>%</strong></td>
                                            <?php
                                                $passPercentage = settings('annual_pass_percentage', 50);
                                                $comment = $studentData['annual_average'] >= $passPercentage ? 'Promoted' : 'Demoted';
                                            ?>
                                            <td><span
                                                    class="badge bg-<?php echo e($studentData['annual_average'] >= $passPercentage ? 'success' : 'danger'); ?>"><?php echo e($comment); ?></span>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Mobile View -->
                        <div class="d-lg-none">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $annualData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $studentData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="card mb-2">
                                    <div class="card-header p-0">
                                        <div class="d-flex">
                                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse"
                                                 data-bs-target="#student<?php echo e($index); ?>" style="cursor: pointer;">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <span
                                                            class="badge bg-light text-dark me-2"><?php echo e($studentData['position_suffix'] ?? ($index + 1)); ?></span>
                                                        <strong><?php echo e($studentData['student']->name); ?></strong>
                                                    </div>
                                                    <div>
                                                        <i class="fas fa-chevron-down text-muted"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse" id="student<?php echo e($index); ?>">
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <div class="d-flex flex-wrap gap-2 mb-2">
                                                    <span
                                                        class="badge bg-primary"><?php echo e($studentData['annual_average']); ?>%</span>
                                                    <?php
                                                        $passPercentage = settings('annual_pass_percentage', 50);
                                                        $comment = $studentData['annual_average'] >= $passPercentage ? 'Promoted' : 'Demoted';
                                                    ?>
                                                    <span
                                                        class="badge bg-<?php echo e($studentData['annual_average'] >= $passPercentage ? 'success' : 'danger'); ?>"><?php echo e($comment); ?></span>
                                                </div>
                                            </div>

                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $sessionData = $studentData['sessions'][$session->id] ?? null;
                                                ?>
                                                <div class="mb-3">
                                                    <h6><?php echo e($session->name); ?></h6>
                                                    <div class="row">
                                                        <div class="col-6">
                                                            <strong>Total:</strong> <?php echo e($sessionData['grand_total'] ?? 0); ?>

                                                        </div>
                                                        <div class="col-6">
                                                            <strong>Average:</strong> <?php echo e($sessionData['average'] ?? 0); ?>

                                                        </div>
                                                    </div>
                                                    <!--[if BLOCK]><![endif]--><?php if(!$loop->last): ?>
                                                        <hr class="my-2">
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            <hr>
                                            <div class="row">
                                                <div class="col-6">
                                                    <strong>Annual
                                                        Total:</strong> <?php echo e($studentData['annual_grand_total']); ?>

                                                </div>
                                                <div class="col-6">
                                                    <strong>Total Average:</strong> <?php echo e($studentData['total_average']); ?>

                                                </div>
                                                <div class="col-12 mt-2">
                                                    <strong>Annual Avg %:</strong> <?php echo e($studentData['annual_average']); ?>%
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Teachers and Timestamp -->
                        <!--[if BLOCK]><![endif]--><?php if(settings('show_class_teachers_online', true) || settings('show_timestamp', true)): ?>
                            <div class="mt-3">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <?php if(settings('show_class_teachers_online', true)): ?>
                                                <div class="col-md-6">
                                                    <h6>Class Teachers:</h6>
                                                    <!--[if BLOCK]><![endif]--><?php if($selectedClass && $selectedClass->teachers && $selectedClass->teachers->count() > 0): ?>
                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $selectedClass->teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <span
                                                                class="badge bg-primary me-1"><?php echo e($teacher->name); ?></span>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                    <?php else: ?>
                                                        <span class="text-muted">No teachers assigned</span>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <!--[if BLOCK]><![endif]--><?php if(settings('show_timestamp', true)): ?>
                                                <div class="col-md-6 text-end">
                                                    <small class="text-muted">Generated
                                                        on: <?php echo e(now()->format('M d, Y \a\t h:i A')); ?></small>
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- Print Button -->
                        <div class="mt-3 text-center">
                            <button onclick="printClassAnnualResult()" class="btn btn-success">
                                <i class="fas fa-print"></i> Print Class Annual Result
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Calculation Help Modal -->
    <div class="modal fade help-modal" id="calculationHelpModal" tabindex="-1"
         aria-labelledby="calculationHelpModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header text-light">
                    <h5 class="modal-title text-light" id="calculationHelpModalLabel">Annual Results Calculation
                        Guide</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body help-modal-body">
                    <div class="row">
                        <div class="col-12">
                            <h6 class="text-primary">Session-Level Calculations</h6>
                            <ul class="list-unstyled">
                                <li><strong>Session Total:</strong> Sum of all subject scores for that session</li>
                                <li><strong>Session Average:</strong> Session Total ÷ Number of Subjects</li>
                                <li><strong>Maximum Session Total:</strong> 100 × Number of Subjects</li>
                            </ul>

                            <h6 class="text-primary mt-4">Annual-Level Calculations</h6>
                            <ul class="list-unstyled">
                                <li><strong>Annual Total:</strong> Sum of all session totals across the academic year
                                </li>
                                <li><strong>Maximum Annual Total:</strong> 100 × Number of Subjects × Number of Sessions
                                </li>
                                <li><strong>Total Average:</strong> Sum of subject averages across all sessions<br>
                                    <small class="text-muted">For each subject: (Sum of session scores ÷ Number of
                                        sessions), then sum all subject averages</small>
                                </li>
                                <li><strong>Maximum Total Average:</strong> 100 × Number of Subjects</li>
                                <li><strong>Annual Avg %:</strong> (Annual Total ÷ Maximum Annual Total) × 100</li>
                                <li><strong>Maximum Annual Avg %:</strong> 100%</li>
                            </ul>

                            <h6 class="text-primary mt-4">Example Calculation</h6>
                            <div class="bg-light p-3 rounded">
                                <p><strong>Scenario:</strong> 3 subjects, 2 sessions</p>
                                <p><strong>Student scores:</strong></p>
                                <ul>
                                    <li>Session 1: Math(80), English(70), Science(90) → Total: 240, Average: 80</li>
                                    <li>Session 2: Math(85), English(75), Science(95) → Total: 255, Average: 85</li>
                                </ul>
                                <p><strong>Annual Calculations:</strong></p>
                                <ul>
                                    <li>Annual Total: 240 + 255 = 495 (Max: 600)</li>
                                    <li>Total Average: Math(82.5) + English(72.5) + Science(92.5) = 247.5 (Max: 300)
                                    </li>
                                    <li>Annual Avg %: (495 ÷ 600) × 100 = 82.5%</li>
                                </ul>
                            </div>

                            <h6 class="text-primary mt-4">Promotion Criteria</h6>
                            <p>Students are promoted if their Annual Avg % meets or exceeds the school's annual pass
                                percentage (configurable in settings).</p>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('livewire:initialized', () => {
        Livewire.on('initClassGradeChart', (data) => {
            setTimeout(() => {
                if (typeof initGradeChart === 'function') {
                    initGradeChart('classGradeChart', data[0].labels, data[0].data, 'Class Performance');
                }
            }, 100);
        });
    });

    function printClassAnnualResult() {
        window.Livewire.find('<?php echo e($_instance->getId()); ?>').
        call('getPrintUrl').then(url => {
            if (url) {
                window.open(url, '_blank', 'width=1200,height=800,scrollbars=yes,resizable=yes');
            }
        });
    }


</script>
<?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/results/annual-results.blade.php ENDPATH**/ ?>