<div>
    <form wire:submit.prevent="save">
        <div class="mb-3">
            <h5 class="mb-2">School Account Details</h5>
            <p class="text-muted small mb-3">Configure up to 3 bank accounts for the school.</p>
        </div>

        <div class="row">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6 mb-3">
                    <div class="card h-100">
                        <div class="card-header py-2">
                            <h6 class="mb-0 small">Account <?php echo e($index + 1); ?></h6>
                        </div>
                        <div class="card-body py-2">
                            <div class="mb-2">
                                <label for="account_number_<?php echo e($index); ?>" class="form-label small mb-1">Account Number</label>
                                <input type="text" class="form-control form-control-sm" 
                                       id="account_number_<?php echo e($index); ?>" 
                                       wire:model="accounts.<?php echo e($index); ?>.account_number" 
                                       placeholder="Account number">
                            </div>
                            <div class="mb-2">
                                <label for="account_name_<?php echo e($index); ?>" class="form-label small mb-1">Account Name</label>
                                <input type="text" class="form-control form-control-sm" 
                                       id="account_name_<?php echo e($index); ?>" 
                                       wire:model="accounts.<?php echo e($index); ?>.account_name" 
                                       placeholder="Account name">
                            </div>
                            <div class="mb-2">
                                <label for="bank_name_<?php echo e($index); ?>" class="form-label small mb-1">Bank Name</label>
                                <input type="text" class="form-control form-control-sm" 
                                       id="bank_name_<?php echo e($index); ?>" 
                                       wire:model="accounts.<?php echo e($index); ?>.bank_name" 
                                       placeholder="Bank name">
                            </div>
                            <div class="mb-0">
                                <label for="currency_<?php echo e($index); ?>" class="form-label small mb-1">Currency</label>
                                <select class="form-select form-select-sm" 
                                        id="currency_<?php echo e($index); ?>" 
                                        wire:model="accounts.<?php echo e($index); ?>.currency">
                                    <option value="NGN">NGN</option>
                                    <option value="USD">USD</option>
                                    <option value="EUR">EUR</option>
                                    <option value="GBP">GBP</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <div class="card mt-4">
            <div class="card-header">
                <h6 class="mb-0">Staff Salary Visibility</h6>
            </div>
            <div class="card-body">
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" id="allowStaffSalaryView" wire:model="allowStaffSalaryView">
                    <label class="form-check-label" for="allowStaffSalaryView">
                        Allow staff to view their salary history
                    </label>
                </div>
                <small class="text-muted">When disabled, staff members will not be able to access their salary history from their dashboard.</small>
            </div>
        </div>

        <div class="d-flex justify-content-end mt-3">
            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                <i class="fas fa-save me-2"></i>
                <span wire:loading.remove>Save Settings</span>
                <span wire:loading>Saving...</span>
            </button>
        </div>
    </form>
</div><?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/settings/finance-settings.blade.php ENDPATH**/ ?>