<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="welcome-card dashboard-welcome">
                    <h1 class="welcome-title text-light">Welcome Back!</h1>
                    <p class="welcome-subtitle text-light"><?php echo e(auth()->user()->name ?? 'User'); ?></p>
                    <?php if($assigned_classes->count() > 0): ?>
                        <div class="mt-3 text-center">
                            <div class="d-flex flex-wrap gap-2 justify-content-center">
                                <?php $__currentLoopData = $assigned_classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge bg-light text-dark px-3 py-2"><?php echo e($class->alias ?: $class->name); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Announcements -->
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('dashboard-announcements', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1587917555-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <!-- Main Stats Cards -->
        <div class="row g-4 mt-3">
            <?php if(auth()->user()->isAdmin() || auth()->user()->isHeadTeacher()): ?>
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon sessions">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                        <div class="card-content">
                            <h3>Current Session</h3>
                            <p class="card-number" style="font-size: 1.2rem; line-height: 1.3;">
                                <?php if($current_session): ?>
                                    <?php echo e($current_session->name); ?><br>
                                    <small style="font-size: 0.9rem; opacity: 0.8;"><?php echo e($current_session->start_year); ?>

                                        /<?php echo e($current_session->end_year); ?></small>
                                <?php else: ?>
                                    None
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if(auth()->user()->isTeacher()): ?>
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon student">
                            <i class="fas fa-user-graduate"></i>
                        </div>
                        <div class="card-content">
                            <h3>My Students</h3>
                            <p class="card-number"><?php echo e(number_format($students_count)); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon classes">
                            <i class="fas fa-school"></i>
                        </div>
                        <div class="card-content">
                            <h3>My Classes</h3>
                            <p class="card-number"><?php echo e(number_format($classes_count)); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon teacher">
                            <i class="fas fa-book"></i>
                        </div>
                        <div class="card-content">
                            <h3>Subjects</h3>
                            <p class="card-number"><?php echo e(number_format($teacher_subjects)); ?></p>
                        </div>
                    </div>
                </div>
            <?php elseif(auth()->user()->isAdmin() || auth()->user()->isHeadTeacher() || auth()->user()->isBursar()): ?>
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon student">
                            <i class="fas fa-user-graduate"></i>
                        </div>
                        <div class="card-content">
                            <h3>Students</h3>
                            <p class="card-number"><?php echo e(number_format($students_count)); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(auth()->user()->isAdmin() || auth()->user()->isHeadTeacher()): ?>
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon teacher">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="card-content">
                            <h3>Staff</h3>
                            <p class="card-number"><?php echo e(number_format($staff_count)); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(auth()->user()->isAdmin() || auth()->user()->isHeadTeacher() || auth()->user()->isBursar()): ?>
            <div class="col-md-6 col-lg-3">
                <div class="dashboard-card">
                    <div class="card-icon classes">
                        <i class="fas fa-school"></i>
                    </div>
                    <div class="card-content">
                        <h3>Classes</h3>
                        <p class="card-number"><?php echo e(number_format($classes_count)); ?></p>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-payments')): ?>
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon payments">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                        <div class="card-content">
                            <h3><?php echo e(auth()->user()->isStudent() ? 'Wallet Balance' : 'Total Wallet Balance'); ?></h3>
                            <p class="card-number">₦<?php echo e(number_format($wallet_balance, 0)); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <?php if(auth()->user()->isTeacher()): ?>
            <div class="row mt-4">
                <div class="col-lg-8">
                    <!-- Additional content can go here -->
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Quick Actions</h4>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="<?php echo e(route('results.by-subject')); ?>" class="btn btn-primary">
                                    <i class="fas fa-edit me-2"></i>Enter Results
                                </a>
                                <a href="<?php echo e(route('results.view-results')); ?>" class="btn btn-info">
                                    <i class="fas fa-eye me-2"></i>View Results
                                </a>
                                <a href="<?php echo e(route('results.offline-upload')); ?>" class="btn btn-success">
                                    <i class="fas fa-file-excel me-2"></i>Upload Results
                                </a>
                                <a href="<?php echo e(route('staff.profile')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-user me-2"></i>My Profile</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.school-portal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\edu-p\resources\views/dashboard.blade.php ENDPATH**/ ?>