<div>
    <div class="row mb-3">
        <div class="col-md-4">
            <input type="text" class="form-control" placeholder="Search batches..." wire:model.live="search">
        </div>
        <div class="col-md-2">
            <select class="form-select" wire:model.live="classFilter">
                <option value="">All Classes</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($class->id); ?>"><?php echo e($class->display_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </select>
        </div>
        <div class="col-md-3">
            <select class="form-select" wire:model.live="statusFilter">
                <option value="active">Active Batches</option>
                <option value="inactive">Inactive Batches</option>
                <option value="graduated">Graduated Batches</option>
                <option value="all">All Batches</option>
            </select>
        </div>
        <div class="col-md-3">
            <select class="form-select" wire:model.live="perPage">
                <option value="10">10 per page</option>
                <option value="25">25 per page</option>
                <option value="50">50 per page</option>
            </select>
        </div>
    </div>

    <!--[if BLOCK]><![endif]--><?php if($batches->count() > 0): ?>
        <!-- Batches Accordions -->
        <div>
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card mb-2">
                    <div class="card-header p-0">
                        <div class="d-flex">
                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse"
                                 data-bs-target="#batch<?php echo e($batch->id); ?>" style="cursor: pointer;">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong><?php echo e($batch->name); ?></strong>
                                        <span class="text-muted ms-2">|</span>
                                        <span class="ms-2"><?php echo e($batch->schoolClass->display_name ?? 'N/A'); ?></span>
                                        <span class="text-muted ms-2">|</span>
                                        <small class="text-muted ms-2"><?php echo e($batch->students->count()); ?>/<?php echo e($batch->capacity); ?> students</small>
                                    </div>
                                    <div>
                                        <!--[if BLOCK]><![endif]--><?php if($batch->graduated): ?>
                                            <span class="badge bg-info me-1">Graduated</span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <span class="badge <?php echo e($batch->is_active ? 'bg-success' : 'bg-secondary'); ?>">
                                            <?php echo e($batch->is_active ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="p-3 border-start">
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary" type="button"
                                            data-bs-toggle="dropdown">
                                        <i class="fas fa-bars"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-sm">
                                        <li><a class="dropdown-item dropdown-item-sm"
                                               href="<?php echo e(route('batches.edit', $batch->id)); ?>">
                                                <i class="fas fa-edit me-2"></i>Edit
                                            </a></li>
                                        <li>
                                            <button
                                                class="dropdown-item dropdown-item-sm text-<?php echo e($batch->is_active ? 'warning' : 'success'); ?>"
                                                onclick="confirmToggleStatus(<?php echo e($batch->id); ?>, <?php echo e($batch->is_active ? 'false' : 'true'); ?>)">
                                                <i class="fas fa-<?php echo e($batch->is_active ? 'pause' : 'play'); ?> me-2"></i><?php echo e($batch->is_active ? 'Deactivate' : 'Activate'); ?>

                                            </button>
                                        </li>
                                        <li>
                                            <button class="dropdown-item dropdown-item-sm text-info"
                                                    onclick="confirmToggleGraduation(<?php echo e($batch->id); ?>, <?php echo e($batch->graduated ? 'false' : 'true'); ?>)">
                                                <i class="fas fa-graduation-cap me-2"></i><?php echo e($batch->graduated ? 'Unmark as Graduated' : 'Mark as Graduated'); ?>

                                            </button>
                                        </li>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin')): ?>
                                        <li>
                                            <hr class="dropdown-divider">
                                        </li>
                                        <li>
                                            <button class="dropdown-item dropdown-item-sm text-danger"
                                                    onclick="confirmDelete(<?php echo e($batch->id); ?>)">
                                                <i class="fas fa-trash me-2"></i>Delete
                                            </button>
                                        </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="collapse" id="batch<?php echo e($batch->id); ?>">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Class:</strong> <?php echo e($batch->schoolClass->display_name ?? 'N/A'); ?></p>
                                    <p><strong>Capacity:</strong> <?php echo e($batch->capacity); ?></p>
                                    <p><strong>Current Students:</strong> <?php echo e($batch->students->count()); ?>/<?php echo e($batch->capacity); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Status:</strong>
                                        <span class="badge <?php echo e($batch->is_active ? 'bg-success' : 'bg-secondary'); ?>">
                                            <?php echo e($batch->is_active ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </p>
                                    <p><strong>Graduated:</strong>
                                        <span class="badge <?php echo e($batch->graduated ? 'bg-info' : 'bg-secondary'); ?>">
                                            <?php echo e($batch->graduated ? 'Yes' : 'No'); ?>

                                        </span>
                                    </p>
                                    <p><strong>Created:</strong> <?php echo e($batch->created_at->format('M d, Y')); ?></p>
                                </div>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if($batch->description): ?>
                                <hr>
                                <p><strong>Description:</strong> <?php echo e($batch->description); ?></p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <!-- Pagination -->
        <!--[if BLOCK]><![endif]--><?php if($batches->hasPages()): ?>
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($batches->links('custom.pagination')); ?>

            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php else: ?>
        <!-- No Batches Notification Card -->
        <div class="alert text-center py-5">
            <div class="mb-3">
                <i class="fas fa-layer-group fa-3x text-muted"></i>
            </div>
            <h4 class="fw-bold mb-3">No Batches Found</h4>
            <p class="mb-4">You haven't created any batches yet. Get started by creating your first batch.</p>
            <a href="<?php echo e(route('batches.create')); ?>" class="btn btn-primary btn-lg">
                <i class="fas fa-plus me-2"></i>Create Your First Batch
            </a>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>

<script>
    function confirmDelete(batchId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: 'var(--primary-color)',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').
                call('deleteBatch', batchId);
            }
        });
    }

    function confirmToggleStatus(batchId, newStatus) {
        const action = newStatus === 'true' ? 'activate' : 'deactivate';
        Swal.fire({
            title: `${action.charAt(0).toUpperCase() + action.slice(1)} Batch?`,
            text: `Are you sure you want to ${action} this batch?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: 'var(--primary-color)',
            cancelButtonColor: '#6c757d',
            confirmButtonText: `Yes, ${action} it!`
        }).then((result) => {
            if (result.isConfirmed) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').
                call('toggleStatus', batchId);
            }
        });
    }

    function confirmToggleGraduation(batchId, newStatus) {
        if (newStatus === true) {
            Swal.fire({
                title: 'Mark as graduated?',
                text: 'Are you sure this batch has graduated and is no longer attending classes?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: 'var(--primary-color)',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, mark as graduated!'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').
                    call('toggleGraduation', batchId);
                }
            });
        } else {
            Swal.fire({
                title: 'Unmark as graduated?',
                text: 'Are you sure you want to restore this batch to active session?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: 'var(--primary-color)',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, restore!'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').
                    call('toggleGraduation', batchId);
                }
            });
        }
    }
</script>
<?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/batches-table.blade.php ENDPATH**/ ?>