<div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title mb-0">Pending Payments</h4>
        </div>
        <div class="card-body">
            <!--[if BLOCK]><![endif]--><?php if($paymentRequests->count() > 0): ?>
                <div class="table-responsive d-none d-md-block">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Title</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $paymentRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($request->title); ?></td>
                                    <td><?php echo e($request->currency_symbol); ?><?php echo e(number_format($request->amount, 0)); ?></td>
                                    <td>
                                        <!--[if BLOCK]><![endif]--><?php if($request->status === 'paid'): ?>
                                            <span class="badge bg-success">Paid</span>
                                        <?php elseif($request->status === 'partial_payment'): ?>
                                            <span class="badge bg-warning">Partial Payment</span>
                                        <?php elseif($request->status === 'processing'): ?>
                                            <span class="badge bg-info">Processing</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Unpaid</span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </td>
                                    <td><?php echo e($request->created_at->format('M d, Y')); ?></td>
                                    <td>
                                        <!--[if BLOCK]><![endif]--><?php if($request->status !== 'paid'): ?>
                                            <button wire:click="makePayment(<?php echo e($request->id); ?>)" 
                                                    class="btn btn-sm btn-primary">
                                                <i class="fas fa-credit-card me-1"></i>Pay Now
                                            </button>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>
                </div>

                <!-- Mobile view -->
                <div class="d-md-none">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $paymentRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card mb-3">
                            <div class="card-body">
                                <h6 class="card-title"><?php echo e($request->title); ?></h6>
                                <p class="card-text">
                                    <strong>Amount:</strong> <?php echo e($request->currency_symbol); ?><?php echo e(number_format($request->amount, 0)); ?><br>
                                    <strong>Status:</strong> 
                                    <!--[if BLOCK]><![endif]--><?php if($request->status === 'paid'): ?>
                                        <span class="badge bg-success">Paid</span>
                                    <?php elseif($request->status === 'partial_payment'): ?>
                                        <span class="badge bg-warning">Partial Payment</span>
                                    <?php elseif($request->status === 'processing'): ?>
                                        <span class="badge bg-info">Processing</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Unpaid</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <br>
                                    <strong>Date:</strong> <?php echo e($request->created_at->format('M d, Y')); ?>

                                </p>
                                <!--[if BLOCK]><![endif]--><?php if($request->status !== 'paid'): ?>
                                    <button wire:click="makePayment(<?php echo e($request->id); ?>)" 
                                            class="btn btn-sm btn-primary">
                                        <i class="fas fa-credit-card me-1"></i>Pay Now
                                    </button>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                <?php echo e($paymentRequests->links('custom.pagination')); ?>

            <?php else: ?>
                <div class="text-center py-4">
                    <i class="fas fa-money-bill-wave fa-3x text-muted mb-3"></i>
                    <h5>No Pending Payments</h5>
                    <p class="text-muted">You have no pending payments at this time.</p>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    <!-- Payment History -->
    <div class="card mt-4">
        <div class="card-header">
            <h4 class="card-title mb-0">Payment History</h4>
        </div>
        <div class="card-body">
            <!--[if BLOCK]><![endif]--><?php if($paymentHistory->count() > 0): ?>
                <div class="table-responsive d-none d-md-block">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Payment ID</th>
                                <th>Title</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $paymentHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($payment->payment_id); ?></td>
                                    <td><?php echo e($payment->paymentRequest->title ?? 'N/A'); ?></td>
                                    <td><?php echo e($payment->currency_symbol); ?><?php echo e(number_format($payment->amount)); ?></td>
                                    <td>
                                        <!--[if BLOCK]><![endif]--><?php if($payment->status === 'successful'): ?>
                                            <span class="badge bg-success">Paid</span>
                                        <?php elseif($payment->status === 'partial'): ?>
                                            <span class="badge bg-warning">Partial</span>
                                        <?php elseif($payment->status === 'processing'): ?>
                                            <span class="badge bg-info">Processing</span>
                                        <?php elseif($payment->status === 'failed'): ?>
                                            <span class="badge bg-danger">Failed</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Pending</span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </td>
                                    <td><?php echo e($payment->created_at->format('M d, Y')); ?></td>
                                    <td>
                                        <button wire:click="viewNotes(<?php echo e($payment->id); ?>)" 
                                                class="btn btn-sm btn-outline-primary me-1 my-1">
                                            <i class="fas fa-eye me-1"></i>Notes
                                        </button>
                                        <!--[if BLOCK]><![endif]--><?php if($payment->status === 'successful'): ?>
                                            <a href="<?php echo e(route('student.payments.receipt', $payment->payment_id)); ?>" 
                                               class="btn btn-sm btn-success my-1">
                                                <i class="fas fa-receipt me-1"></i>Receipt
                                            </a>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>
                </div>

                <!-- Mobile view -->
                <div class="d-md-none">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $paymentHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card mb-3">
                            <div class="card-body">
                                <h6 class="card-title"><?php echo e($payment->paymentRequest->title ?? 'N/A'); ?></h6>
                                <p class="card-text">
                                    <strong>Payment ID:</strong> <?php echo e($payment->payment_id); ?><br>
                                    <strong>Amount:</strong> <?php echo e($payment->currency_symbol); ?><?php echo e(number_format($payment->amount)); ?><br>
                                    <strong>Status:</strong> 
                                    <!--[if BLOCK]><![endif]--><?php if($payment->status === 'successful'): ?>
                                        <span class="badge bg-success">Paid</span>
                                    <?php elseif($payment->status === 'partial'): ?>
                                        <span class="badge bg-warning">Partial</span>
                                    <?php elseif($payment->status === 'processing'): ?>
                                        <span class="badge bg-info">Processing</span>
                                    <?php elseif($payment->status === 'failed'): ?>
                                        <span class="badge bg-danger">Failed</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Pending</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <br>
                                    <strong>Date:</strong> <?php echo e($payment->created_at->format('M d, Y')); ?>

                                </p>
                                <button wire:click="viewNotes(<?php echo e($payment->id); ?>)" 
                                        class="btn btn-sm btn-outline-primary me-1 my-1">
                                    <i class="fas fa-eye me-1"></i>Notes
                                </button>
                                <!--[if BLOCK]><![endif]--><?php if($payment->status === 'successful'): ?>
                                    <a href="<?php echo e(route('student.payments.receipt', $payment->payment_id)); ?>" 
                                       class="btn btn-sm btn-success my-1">
                                        <i class="fas fa-receipt me-1"></i>Receipt
                                    </a>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                <?php echo e($paymentHistory->links('custom.pagination', ['pageName' => 'historyPage'])); ?>

            <?php else: ?>
                <div class="text-center py-4">
                    <i class="fas fa-history fa-3x text-muted mb-3"></i>
                    <h5>No Payment History</h5>
                    <p class="text-muted">You have no payment history at this time.</p>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    <!-- Payment Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showPaymentModal): ?>
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title text-light">Make Payment</h5>
                        <button type="button" class="btn-close" wire:click="closeModal"></button>
                    </div>
                    <div class="modal-body">
                        <!--[if BLOCK]><![endif]--><?php if($selectedPaymentRequest): ?>
                            <div class="mb-4">
                                <h4><?php echo e($selectedPaymentRequest->title); ?></h4>
                                <p class="text-muted"><?php echo e($selectedPaymentRequest->description); ?></p>
                                <p><strong>Amount:</strong> <?php echo e($selectedPaymentRequest->currency_symbol); ?><?php echo e(number_format($selectedPaymentRequest->amount, 0)); ?></p>
                            </div>

                            <!--[if BLOCK]><![endif]--><?php if($hasPendingPayment): ?>
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <strong>Payment Pending:</strong> You have already submitted a payment confirmation for this request. Please remember to make the transfer to one of the designated accounts below.
                                </div>
                            <?php else: ?>
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    <strong>Payment Instructions:</strong> Please make a transfer to any of the accounts below, then click "I have paid" to confirm your payment.
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!--[if BLOCK]><![endif]--><?php if(count($schoolAccounts) > 0): ?>
                                <h6 class="mb-3">School Account Details</h6>
                                <div class="row">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $schoolAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <!--[if BLOCK]><![endif]--><?php if(!empty($account['account_number']) && !empty($account['account_name'])): ?>
                                            <div class="col-md-6 mb-3">
                                                <div class="card">
                                                    <div class="card-body">
                                                        <h6 class="card-title"><?php echo e($account['bank_name'] ?? 'Bank Account ' . ($index + 1)); ?></h6>
                                                        <p class="card-text mb-1"><strong>Account Name:</strong> <?php echo e($account['account_name']); ?></p>
                                                        <p class="card-text mb-1"><strong>Account Number:</strong> <?php echo e($account['account_number']); ?></p>
                                                        <p class="card-text mb-0"><strong>Currency:</strong> <?php echo e($account['currency'] ?? 'NGN'); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php else: ?>
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    No account details available. Please contact the school administration.
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeModal">Close</button>
                        <button type="button" class="btn btn-primary <?php if($hasPendingPayment): ?> opacity-50 <?php endif; ?>" 
                                wire:click="confirmPayment" <?php if($hasPendingPayment): ?> disabled <?php endif; ?> wire:loading.attr="disabled">
                            <i class="fas fa-check me-2" wire:loading.remove wire:target="confirmPayment"></i>
                            <i class="fas fa-spinner fa-spin me-2" wire:loading wire:target="confirmPayment"></i>
                            <span wire:loading.remove wire:target="confirmPayment">I have paid</span>
                            <span wire:loading wire:target="confirmPayment">Processing...</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Notes Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showNotesModal): ?>
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title text-light">Payment Notes</h5>
                        <button type="button" class="btn-close" wire:click="closeNotesModal"></button>
                    </div>
                    <div class="modal-body">
                        <!--[if BLOCK]><![endif]--><?php if($selectedPayment): ?>
                            <div class="mb-3">
                                <strong>Payment ID:</strong> <?php echo e($selectedPayment->payment_id); ?>

                            </div>
                            <div class="mb-3">
                                <strong>Amount:</strong> <?php echo e($selectedPayment->currency_symbol); ?><?php echo e(number_format($selectedPayment->amount)); ?>

                            </div>
                            <div class="mb-3">
                                <strong>Status:</strong> 
                                <!--[if BLOCK]><![endif]--><?php if($selectedPayment->status === 'successful'): ?>
                                    <span class="badge bg-success">Paid</span>
                                <?php elseif($selectedPayment->status === 'partial'): ?>
                                    <span class="badge bg-warning">Partial</span>
                                <?php elseif($selectedPayment->status === 'processing'): ?>
                                    <span class="badge bg-info">Processing</span>
                                <?php elseif($selectedPayment->status === 'failed'): ?>
                                    <span class="badge bg-danger">Failed</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Pending</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="mb-3">
                                <strong>Date:</strong> <?php echo e($selectedPayment->created_at->format('M d, Y g:i A')); ?>

                            </div>
                            <div>
                                <strong>Notes:</strong>
                                <div class="mt-2 p-3 bg-light rounded">
                                    <?php echo e($selectedPayment->notes ?: 'No notes available.'); ?>

                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeNotesModal">Close</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/student/student-payments.blade.php ENDPATH**/ ?>