<div>
    <form wire:submit.prevent="approveResults">
        <div class="row mb-4">
            <div class="col-md-6 col-lg-3">
                <label for="selectedSession" class="form-label">Select Session</label>
                <select wire:model.live="selectedSession" class="form-select" id="selectedSession">
                    <option value="">Choose a session...</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($session->id); ?>"><?php echo e($session->name); ?> (<?php echo e($session->start_year); ?>/<?php echo e($session->end_year); ?>)</option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedSession'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="col-md-6 col-lg-3">
                <label for="selectedClass" class="form-label">Select Class</label>
                <select wire:model.live="selectedClass" class="form-select" id="selectedClass" <?php echo e(!$selectedSession ? 'disabled' : ''); ?>>
                    <option value="">Choose a class...</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($class->id); ?>"><?php echo e($class->display_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedClass'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="col-md-6 col-lg-3">
                <label for="selectedBatch" class="form-label">Select Batch</label>
                <select wire:model.live="selectedBatch" class="form-select" id="selectedBatch" <?php echo e(!$selectedClass ? 'disabled' : ''); ?>>
                    <option value="">Choose a batch...</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($batch->id); ?>"><?php echo e($batch->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedBatch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="col-md-6 col-lg-3">
                <!--[if BLOCK]><![endif]--><?php if(!empty($selectedStudents) && $selectedSession): ?>
                    <label class="form-label">&nbsp;</label>
                    <button type="button" 
                            wire:click="loadStudentResults" 
                            class="btn btn-primary btn-lg d-block"
                            wire:loading.attr="disabled"
                            wire:target="loadStudentResults">
                        <span wire:loading.remove wire:target="loadStudentResults">
                            <i class="fas fa-sync me-2"></i>Load Results
                        </span>
                        <span wire:loading wire:target="loadStudentResults">
                            <i class="fas fa-spinner fa-spin me-2"></i>Loading...
                        </span>
                    </button>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
        
        <!--[if BLOCK]><![endif]--><?php if($selectedSession && $selectedClass && $selectedBatch): ?>
            <div class="row mb-4">
                <div class="col-md-12">
                    <label class="form-label">Select Students</label>
                    <div class="border rounded p-3" style="max-height: 300px; overflow-y: auto;">
                        <!--[if BLOCK]><![endif]--><?php if(count($students) > 0): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" wire:model.live="selectedStudents" wire:change="loadStudentResults" value="<?php echo e($student->id); ?>" id="student_<?php echo e($student->id); ?>">
                                    <label class="form-check-label" for="student_<?php echo e($student->id); ?>">
                                        <?php echo e($student->name); ?> (<?php echo e($student->student_id); ?>)
                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        <?php else: ?>
                            <div class="alert alert-info mb-0">
                                <i class="fas fa-info-circle me-2"></i>
                                <strong>No students meet the search criteria.</strong><br>
                                It appears all student results for the selected class, batch, and session have been approved.
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <small class="text-muted">Select multiple students by checking boxes (excludes students with already approved results)</small>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedStudents'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!--[if BLOCK]><![endif]--><?php if(!empty($studentResults)): ?>
            <div class="card mb-5">
                <div class="card-header">
                    <h5 class="mb-0">Student Results Summary</h5>
                </div>
                <div class="card-body">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $studentResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentId => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-3">
                            <h6><?php echo e($data['student']->name); ?></h6>
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Subject</th>
                                            <th>CA Score</th>
                                            <th>Exam Score</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['results']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($result['subject']->display_name); ?></td>
                                                <td><?php echo e($result['ca_score']); ?></td>
                                                <td><?php echo e($result['exam_score']); ?></td>
                                                <td><strong><?php echo e($result['total_score']); ?></strong></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        <tr class="table-info">
                                            <td colspan="3"><strong>Grand Total</strong></td>
                                            <td><strong><?php echo e($data['total']); ?></strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Affective Traits</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Punctuality</label>
                                    <input type="number" wire:model="punctuality" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['punctuality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Mental Alertness</label>
                                    <input type="number" wire:model="mental_alertness" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['mental_alertness'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Attentiveness</label>
                                    <input type="number" wire:model="attentiveness" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['attentiveness'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Respect</label>
                                    <input type="number" wire:model="respect" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['respect'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Neatness</label>
                                    <input type="number" wire:model="neatness" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['neatness'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Politeness</label>
                                    <input type="number" wire:model="politeness" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['politeness'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Honesty</label>
                                    <input type="number" wire:model="honesty" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['honesty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Relationship with Peers</label>
                                    <input type="number" wire:model="relationship_with_peers" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['relationship_with_peers'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Attitude to School</label>
                                    <input type="number" wire:model="attitude_to_school" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['attitude_to_school'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Teamwork</label>
                                    <input type="number" wire:model="teamwork" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['teamwork'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-12 mb-3">
                                    <label class="form-label">Completes School Work Promptly</label>
                                    <input type="number" wire:model="completes_school_work_promptly" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['completes_school_work_promptly'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Psychomotor Skills</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Reading</label>
                                    <input type="number" wire:model="reading" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['reading'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Verbal Fluency/Diction</label>
                                    <input type="number" wire:model="verbal_fluency_diction" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['verbal_fluency_diction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Handwriting</label>
                                    <input type="number" wire:model="handwriting" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['handwriting'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Musical Skills</label>
                                    <input type="number" wire:model="musical_skills" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['musical_skills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Creative Arts</label>
                                    <input type="number" wire:model="creative_arts" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['creative_arts'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Physical Education</label>
                                    <input type="number" wire:model="physical_education" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['physical_education'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-12 mb-3">
                                    <label class="form-label">General Reasoning</label>
                                    <input type="number" wire:model="general_reasoning" class="form-control" min="0" max="5" step="0.1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['general_reasoning'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="mb-0">Principal/Head Teacher's Remarks</h5>
                </div>
                <div class="card-body">
                    <textarea wire:model="principal_remarks" class="form-control" rows="4" placeholder="Enter remarks..."></textarea>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['principal_remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

            <div class="d-flex justify-content-end mt-4">
                <button type="submit" 
                        class="btn btn-success btn-lg"
                        wire:loading.attr="disabled"
                        wire:target="approveResults">
                    <span wire:loading.remove wire:target="approveResults">
                        <i class="fas fa-check me-2"></i>Approve Results
                    </span>
                    <span wire:loading wire:target="approveResults">
                        <i class="fas fa-spinner fa-spin me-2"></i>Processing...
                    </span>
                </button>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </form>
</div>

<?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/results/approval-form.blade.php ENDPATH**/ ?>