<?php
    $helpers = app('App\Services\AnnualResultService')->getCalculationHelpers($data['sessions'], $data['subjects'], $data['studentData']);
    $annualMaxTotal = $helpers['annual_max_total'];
    $correctedAnnualAverage = $helpers['corrected_annual_average'];
    $promotionStatus = $helpers['promotion_status'];
?>

<!-- Student Info Header -->
<div class="row mb-4">
    <div class="col-md-8">
        <div class="card bg-light">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <h5 class="mb-3"><?php echo e($data['student']->firstname); ?> <?php echo e($data['student']->middlename); ?> <?php echo e($data['student']->surname); ?></h5>
                        <p class="mb-1"><strong>Student ID:</strong> <?php echo e($data['student']->student_id ?? 'N/A'); ?></p>
                        <p class="mb-1"><strong>Class:</strong> <?php echo e($data['class']->alias ?: $data['class']->name); ?></p>
                        <p class="mb-1"><strong>Academic Year:</strong> <?php echo e($data['year']); ?>/<?php echo e($data['year'] + 1); ?></p>
                        <p class="mb-0"><strong>Gender:</strong> <?php echo e(ucfirst($data['student']->gender ?? 'N/A')); ?></p>
                    </div>
                    <div class="col-md-4 text-center">
                        <img src="<?php echo e($data['student']->profile_photo ? asset('storage/' . $data['student']->profile_photo) : asset('images/user-avatar.png')); ?>" 
                             alt="Student Photo" class="img-thumbnail" style="width: 100px; height: 100px; object-fit: cover;">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <!-- Summary Cards -->
        <div class="row">
            <div class="col-6 mb-2">
                <div class="card text-center bg-primary text-white">
                    <div class="card-body py-2">
                        <span class="fw-bold fs-6 text-light d-block mb-1">Annual Total</span>
                        <h5 class="mb-0 text-light"><?php echo e($data['studentData']['annual_grand_total']); ?>/<?php echo e($annualMaxTotal); ?></h5>
                    </div>
                </div>
            </div>
            <div class="col-6 mb-2">
                <div class="card text-center bg-success text-white">
                    <div class="card-body py-2">
                        <span class="fw-bold fs-6 text-light d-block mb-1">Annual Score %</span>
                        <h5 class="mb-0 text-light"><?php echo e($correctedAnnualAverage); ?>%</h5>
                    </div>
                </div>
            </div>
            <div class="col-6 mb-2">
                <div class="card text-center bg-info text-white">
                    <div class="card-body py-2">
                        <span class="fw-bold fs-6 text-light d-block mb-1">Sessions</span>
                        <h5 class="mb-0 text-light"><?php echo e($data['studentData']['session_count']); ?></h5>
                    </div>
                </div>
            </div>
            <div class="col-6 mb-2">
                <div class="card text-center <?php echo e($promotionStatus['is_promoted'] ? 'bg-success' : 'bg-danger'); ?> text-white">
                    <div class="card-body py-2">
                        <span class="fw-bold fs-6 text-light d-block mb-1">Status</span>
                        <h5 class="mb-0 text-light"><?php echo e($promotionStatus['comment']); ?></h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Results Table -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <span class="fw-bold fs-5 d-block mb-0">Session-wise Results</span>
            </div>
            <div class="card-body">
                <!-- Desktop View -->
                <div class="d-none d-lg-block">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped text-center align-middle">
                            <thead class="table-dark">
                            <tr>
                                <th rowspan="2">Subject</th>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['sessions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th colspan="4" class="text-center"><?php echo e($session->name); ?></th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </tr>
                            <tr>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['sessions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th>CA</th>
                                    <th>Exam</th>
                                    <th>Total</th>
                                    <th>Grade</th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </tr>
                            </thead>
                            <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-start"><strong><?php echo e($subject->display_name); ?></strong></td>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['sessions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $result = $data['studentData']['sessions'][$session->id]['subjects'][$subject->id] ?? null;
                                        ?>
                                        <td><?php echo e(app('App\Services\AnnualResultService')->formatResultValue($result['ca_score'] ?? 0)); ?></td>
                                        <td><?php echo e(app('App\Services\AnnualResultService')->formatResultValue($result['exam_score'] ?? 0)); ?></td>
                                        <td><strong><?php echo e(app('App\Services\AnnualResultService')->formatResultValue($result['total'] ?? 0)); ?></strong></td>
                                        <td><?php echo e(app('App\Services\AnnualResultService')->formatResultValue($result['grade'] ?? 'F')); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            <tr class="table-info">
                                <td class="text-start"><strong>Session Total</strong></td>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['sessions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td></td>
                                    <td></td>
                                    <?php
                                        $sessionMaxTotal = app('App\Services\AnnualResultService')->calculateSessionMaxTotal($session->id, $data['subjects'], $data['studentData']);
                                    ?>
                                    <td><strong><?php echo e($data['studentData']['sessions'][$session->id]['grand_total']); ?>/<?php echo e($sessionMaxTotal); ?></strong></td>
                                    <td></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </tr>
                            <tr class="table-warning">
                                <td class="text-start"><strong>Session Average</strong></td>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['sessions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td></td>
                                    <td></td>
                                    <td><strong><?php echo e($data['studentData']['sessions'][$session->id]['average']); ?></strong></td>
                                    <td></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Mobile View -->
                <div class="d-lg-none">
                    <div class="accordion" id="sessionAccordion">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['sessions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse"
                                            data-bs-target="#collapse<?php echo e($index); ?>" aria-expanded="false">
                                        <strong><?php echo e($session->name); ?></strong>
                                        <span class="ms-auto me-3">
                                            <?php
                                                $sessionMaxTotal = app('App\Services\AnnualResultService')->calculateSessionMaxTotal($session->id, $data['subjects'], $data['studentData']);
                                            ?>
                                            <small class="text-muted">Total: <?php echo e($data['studentData']['sessions'][$session->id]['grand_total']); ?>/<?php echo e($sessionMaxTotal); ?> (<?php echo e($data['studentData']['sessions'][$session->id]['average']); ?>%)</small>
                                        </span>
                                    </button>
                                </h2>
                                <div id="collapse<?php echo e($index); ?>" class="accordion-collapse collapse"
                                     data-bs-parent="#sessionAccordion">
                                    <div class="accordion-body">
                                        <div class="table-responsive">
                                            <table class="table table-sm">
                                                <thead>
                                                <tr>
                                                    <th>Subject</th>
                                                    <th>CA</th>
                                                    <th>Exam</th>
                                                    <th>Total</th>
                                                    <th>Grade</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $data['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $result = $data['studentData']['sessions'][$session->id]['subjects'][$subject->id] ?? null;
                                                    ?>
                                                    <tr>
                                                        <td><?php echo e($subject->display_name); ?></td>
                                                        <td><?php echo e(app('App\Services\AnnualResultService')->formatResultValue($result['ca_score'] ?? 0)); ?></td>
                                                        <td><?php echo e(app('App\Services\AnnualResultService')->formatResultValue($result['exam_score'] ?? 0)); ?></td>
                                                        <td><strong><?php echo e(app('App\Services\AnnualResultService')->formatResultValue($result['total'] ?? 0)); ?></strong></td>
                                                        <td><?php echo e(app('App\Services\AnnualResultService')->formatResultValue($result['grade'] ?? 'F')); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--[if BLOCK]><![endif]--><?php if($data['approval']): ?>
<!-- Affective Traits and Psychomotor Skills -->
<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <span class="fw-bold fs-6 text-white d-block mb-0">Affective Traits</span>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6"><strong>Punctuality:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->punctuality)); ?>/5</div>
                    <div class="col-6"><strong>Mental Alertness:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->mental_alertness)); ?>/5</div>
                    <div class="col-6"><strong>Attentiveness:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->attentiveness)); ?>/5</div>
                    <div class="col-6"><strong>Respect:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->respect)); ?>/5</div>
                    <div class="col-6"><strong>Neatness:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->neatness)); ?>/5</div>
                    <div class="col-6"><strong>Politeness:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->politeness)); ?>/5</div>
                    <div class="col-6"><strong>Honesty:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->honesty)); ?>/5</div>
                    <div class="col-6"><strong>Relationship with Peers:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->relationship_with_peers)); ?>/5</div>
                    <div class="col-6"><strong>Attitude to School:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->attitude_to_school)); ?>/5</div>
                    <div class="col-6"><strong>Teamwork:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->teamwork)); ?>/5</div>
                    <div class="col-6"><strong>Completes Work Promptly:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->completes_school_work_promptly)); ?>/5</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-success text-white">
                <span class="fw-bold fs-6 text-white d-block mb-0">Psychomotor Skills</span>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6"><strong>Reading:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->reading)); ?>/5</div>
                    <div class="col-6"><strong>Verbal Fluency/Diction:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->verbal_fluency_diction)); ?>/5</div>
                    <div class="col-6"><strong>Handwriting:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->handwriting)); ?>/5</div>
                    <div class="col-6"><strong>Musical Skills:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->musical_skills)); ?>/5</div>
                    <div class="col-6"><strong>Creative Arts:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->creative_arts)); ?>/5</div>
                    <div class="col-6"><strong>Physical Education:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->physical_education)); ?>/5</div>
                    <div class="col-6"><strong>General Reasoning:</strong></div>
                    <div class="col-6"><?php echo e(intval($data['approval']->general_reasoning)); ?>/5</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Principal's Remarks -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-info text-white">
                <span class="fw-bold fs-6 text-white d-block mb-0">Head Teacher's Remarks</span>
            </div>
            <div class="card-body">
                <p class="mb-0"><?php echo e($data['approval']->principal_remarks); ?></p>
            </div>
        </div>
    </div>
</div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->

<!-- Grade Distribution -->
<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <span class="fw-bold fs-6 d-block mb-0">Annual Grade Distribution</span>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = ['A', 'B', 'C', 'D', 'E', 'F']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-2 mb-2">
                            <div class="badge bg-<?php echo e($grade === 'A' ? 'success' : ($grade === 'F' ? 'danger' : 'secondary')); ?> p-2 w-100">
                                <div><?php echo e($grade); ?></div>
                                <div class="h6 mb-0"><?php echo e($data['studentData']['annual_grades'][$grade]); ?></div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <span class="fw-bold fs-6 d-block mb-0">Annual Summary</span>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6"><strong>Annual Total:</strong></div>
                    <div class="col-6"><?php echo e($data['studentData']['annual_grand_total']); ?>/<?php echo e($annualMaxTotal); ?></div>
                    <div class="col-6"><strong>Annual Score %:</strong></div>
                    <div class="col-6"><?php echo e($correctedAnnualAverage); ?>%</div>
                    <div class="col-6"><strong>Sessions Completed:</strong></div>
                    <div class="col-6"><?php echo e($data['studentData']['session_count']); ?></div>
                    <div class="col-6"><strong>Total Subjects:</strong></div>
                    <div class="col-6"><?php echo e(count($data['subjects'])); ?></div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--[if BLOCK]><![endif]--><?php if(isset($qrCode) && $qrCode): ?>
<!-- QR Code -->
<div class="row mt-4">
    <div class="col-12 text-center">
        <div class="card">
            <div class="card-body">
                <?php echo $qrCode; ?>

                <p class="mt-2 text-muted">Scan to verify result authenticity</p>
            </div>
        </div>
    </div>
</div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]--><?php /**PATH C:\wamp64\www\edu-p\resources\views/results/partials/student-annual-result-display.blade.php ENDPATH**/ ?>