<?php $__env->startSection('title', 'My Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">My Profile</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-4">
            <div class="card mb-3">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <?php if($staff->profile_photo): ?>
                            <img src="<?php echo e(asset('storage/' . $staff->profile_photo)); ?>" 
                                 alt="Profile Photo" class="rounded-circle" width="120" height="120">
                        <?php else: ?>
                            <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" 
                                 style="width: 120px; height: 120px;">
                                <span class="text-white fs-1"><?php echo e($staff->initials()); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <h5 class="mb-1"><?php echo e($staff->name); ?></h5>
                    <p class="text-muted"><?php echo e($staff->username); ?></p>
                    <p class="text-muted">
                        <?php $__currentLoopData = $staff->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="badge bg-primary"><?php echo e(ucwords(str_replace('_', ' ', $role->name))); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </p>
                </div>
            </div>

            <?php if($staff->hasAnyRole(['admin', 'bursar', 'head_teacher'])): ?>
            <div class="card mb-3">
                <div class="card-header">
                    <h4 class="card-title mb-0">Change Password</h4>
                </div>
                <div class="card-body">
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('staff.change-password-form');

$__html = app('livewire')->mount($__name, $__params, 'lw-1164811023-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <div class="col-lg-8">
            <div class="card mb-3">
                <div class="card-header">
                    <h4 class="card-title mb-0">Personal Information</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">First Name</label>
                            <p><?php echo e($staff->firstname); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Middle Name</label>
                            <p><?php echo e($staff->middlename ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Surname</label>
                            <p><?php echo e($staff->surname); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Gender</label>
                            <p><?php echo e(ucfirst($staff->gender)); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Date of Birth</label>
                            <p><?php echo e($staff->dob ? \Carbon\Carbon::parse($staff->dob)->format('M d, Y') : 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Marital Status</label>
                            <p><?php echo e($staff->marital_status ? ucfirst($staff->marital_status) : 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Email</label>
                            <p><?php echo e($staff->email ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Phone</label>
                            <p><?php echo e($staff->phone ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label fw-bold">Address</label>
                            <p><?php echo e($staff->address ?: 'N/A'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <?php if($staff->isTeacher()): ?>
            <div class="card mb-3">
                <div class="card-header">
                    <h4 class="card-title mb-0">Assigned Classes</h4>
                </div>
                <div class="card-body">
                    <?php if($staff->classes->count() > 0): ?>
                        <div class="row">
                            <?php $__currentLoopData = $staff->classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6 mb-2">
                                    <span class="badge bg-info"><?php echo e($class->name); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">No classes assigned yet.</p>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if($staff->monthly_salary): ?>
            <div class="card mb-3">
                <div class="card-header">
                    <h4 class="card-title mb-0">Payroll Information</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php if(\App\Models\Setting::get('allow_staff_salary_view', true)): ?>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Monthly Salary</label>
                            <p>₦<?php echo e(number_format($staff->monthly_salary, 2)); ?></p>
                        </div>
                        <?php endif; ?>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Payment Day</label>
                            <p><?php echo e($staff->payment_day ? ordinal($staff->payment_day) . ' of each month' : 'Last day of month'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Bank Name</label>
                            <p><?php echo e($staff->bank_name ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Account Number</label>
                            <p><?php echo e($staff->account_number ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Account Name</label>
                            <p><?php echo e($staff->account_name ?: 'N/A'); ?></p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Tax ID</label>
                            <p><?php echo e($staff->tax_id ?: 'N/A'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
function ordinal($number) {
    $ends = ['th','st','nd','rd','th','th','th','th','th','th'];
    if ((($number % 100) >= 11) && (($number % 100) <= 13))
        return $number. 'th';
    else
        return $number. $ends[$number % 10];
}
?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.school-portal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\edu-p\resources\views/staff/profile/show.blade.php ENDPATH**/ ?>