<div>
    <!-- Search and Pagination Row (Medium+ screens) -->
    <div class="row mb-2 d-none d-md-flex">
        <div class="col-md-8">
            <input type="text" class="form-control" placeholder="Search staff..." wire:model.live="search">
        </div>
        <div class="col-md-4">
            <select class="form-select" wire:model.live="perPage">
                <option value="10">10 per page</option>
                <option value="25">25 per page</option>
                <option value="50">50 per page</option>
            </select>
        </div>
    </div>
    
    <!-- Search Row (Mobile only) -->
    <div class="row mb-2 d-md-none">
        <div class="col-12">
            <input type="text" class="form-control" placeholder="Search staff..." wire:model.live="search">
        </div>
    </div>
    
    <!-- Filters Row -->
    <div class="row mb-3">
        <div class="col-lg-6 col-md-6 col-sm-6 mb-2">
            <select class="form-select" wire:model.live="roleFilter">
                <option value="">All Roles</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($role->name); ?>"><?php echo e($role->display_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </select>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 mb-2">
            <select class="form-select" wire:model.live="statusFilter">
                <option value="">All Status</option>
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
            </select>
        </div>
        <!-- Pagination dropdown for mobile only -->
        <div class="col-12 d-md-none mb-2">
            <select class="form-select" wire:model.live="perPage">
                <option value="10">10 per page</option>
                <option value="25">25 per page</option>
                <option value="50">50 per page</option>
            </select>
        </div>
    </div>

    <!-- Staff Accordions -->
    <div>
        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="card mb-2">
                <div class="card-header p-0">
                    <div class="d-flex">
                        <div class="flex-grow-1 p-3" data-bs-toggle="collapse" data-bs-target="#staff<?php echo e($member->id); ?>" style="cursor: pointer;">
                            <div class="d-flex justify-content-between align-items-center">
                                <!-- Desktop and Medium screen view -->
                                <div class="d-none d-md-block">
                                    <span class="badge bg-light text-dark me-2"><?php echo e($staff->firstItem() + $index); ?></span>
                                    <strong><?php echo e($member->name); ?></strong>
                                    <!--[if BLOCK]><![endif]--><?php if($member->roles->count()): ?>
                                        <span class="badge bg-primary ms-2"><?php echo e($member->roles->first()->display_name); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary ms-2">No Role</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                
                                <!-- Mobile view - show only name and number -->
                                <div class="d-md-none">
                                    <span class="badge bg-light text-dark me-2"><?php echo e($staff->firstItem() + $index); ?></span>
                                    <strong><?php echo e($member->name); ?></strong>
                                </div>
                                
                                <!-- Desktop status badges -->
                                <div class="d-none d-md-block">
                                    <!--[if BLOCK]><![endif]--><?php if($member->active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactive</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                
                                <!-- Mobile chevron -->
                                <div class="d-md-none">
                                    <i class="fas fa-chevron-down text-muted"></i>
                                </div>
                            </div>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($member->username): ?>
                            <div class="p-3 border-start">
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary" type="button" data-bs-toggle="dropdown">
                                        <i class="fas fa-bars"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-sm">
                                        <li><a class="dropdown-item dropdown-item-sm" href="<?php echo e(route('staff.show', $member->username)); ?>">
                                            <i class="fas fa-eye me-2"></i>View Profile
                                        </a></li>
                                        <li><a class="dropdown-item dropdown-item-sm" href="<?php echo e(route('staff.edit', $member->username)); ?>">
                                            <i class="fas fa-edit me-2"></i>Edit
                                        </a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><button class="dropdown-item dropdown-item-sm text-warning" onclick="confirmDeactivate('<?php echo e($member->id); ?>', '<?php echo e($member->name); ?>')">
                                            <i class="fas fa-ban me-2"></i><?php echo e($member->active ? 'Deactivate' : 'Activate'); ?>

                                        </button></li>
                                    </ul>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
                <div class="collapse" id="staff<?php echo e($member->id); ?>">
                    <div class="card-body">
                        <!-- Mobile status info -->
                        <div class="d-md-none mb-3">
                            <div class="d-flex flex-wrap gap-2 mb-2">
                                <!--[if BLOCK]><![endif]--><?php if($member->roles->count()): ?>
                                    <span class="badge bg-primary"><?php echo e($member->roles->first()->display_name); ?></span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">No Role</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($member->active): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Inactive</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-3 text-center mb-3">
                                <!--[if BLOCK]><![endif]--><?php if($member->profile_photo): ?>
                                    <img src="<?php echo e(asset('storage/' . $member->profile_photo)); ?>" alt="<?php echo e($member->name); ?>" 
                                         class="img-thumbnail rounded" style="width: 120px; height: 120px; object-fit: cover;" loading="lazy">
                                <?php else: ?>
                                    <div class="bg-light border rounded d-inline-flex align-items-center justify-content-center" 
                                         style="width: 120px; height: 120px;">
                                        <i class="fas fa-user text-muted" style="font-size: 45px;"></i>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-4">
                                <p><strong>Username:</strong> <code><?php echo e($member->username); ?></code></p>
                                <p><strong>Email:</strong> <?php echo e($member->email); ?></p>
                                <p><strong>Phone:</strong> <?php echo e($member->phone ?: 'N/A'); ?></p>
                            </div>
                            <div class="col-md-5">
                                <!--[if BLOCK]><![endif]--><?php if($member->classes->count()): ?>
                                    <p><strong>Assigned Classes:</strong></p>
                                    <div>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $member->classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-info me-1 mb-1"><?php echo e($class->display_name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                <?php else: ?>
                                    <p><strong>Assigned Classes:</strong> <span class="text-muted">None</span></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center py-4">
                <p>No staff found</p>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-center">
        <?php echo e($staff->links('custom.pagination')); ?>

    </div>
</div>

<script>
function confirmDeactivate(staffId, staffName) {
    Swal.fire({
        title: 'Toggle Staff Status?',
        text: `Are you sure you want to change ${staffName}'s access status?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: 'var(--primary-color)',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, Change Status',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            window.Livewire.find('<?php echo e($_instance->getId()); ?>').deactivateStaff(staffId);
        }
    });
}
</script><?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/staff-table.blade.php ENDPATH**/ ?>