<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">Master List</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-4 align-items-center">
                        <div class="col-md-6 col-lg-3">
                            <label for="sessionSelect" class="form-label">Select Session</label>
                            <select wire:model.live="sessionId" id="sessionSelect" class="form-select">
                                <option value="">Choose Session...</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($session->id); ?>"><?php echo e($session->start_year); ?>/<?php echo e($session->end_year); ?> - <?php echo e($session->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <div class="col-md-6 col-lg-3">
                            <label for="classSelect" class="form-label">Select Class</label>
                            <select wire:model.live="classId" id="classSelect" class="form-select">
                                <option value="">Choose Class...</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($class->id); ?>"><?php echo e($class->display_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <div class="col-md-12 col-lg-3">
                            <label for="batchSelect" class="form-label">Select Batch (Optional)</label>
                            <select wire:model.live="batchId" id="batchSelect" class="form-select" <?php echo e(!$classId ? 'disabled' : ''); ?>>
                                <option value="">All Batches</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($batch->id); ?>"><?php echo e($batch->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <div class="col-12 col-lg-3 d-lg-flex align-items-end">
                            <button wire:click="loadMasterList" 
                                    class="btn <?php echo e(!$sessionId || !$classId ? 'btn-secondary' : 'btn-primary'); ?> w-100" 
                                    wire:loading.attr="disabled"
                                    <?php echo e(!$sessionId || !$classId ? 'disabled' : ''); ?>>
                                <span wire:loading.remove wire:target="loadMasterList">
                                    <i class="fas fa-list-alt me-2"></i>Load
                                </span>
                                <span wire:loading wire:target="loadMasterList">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Loading...
                                </span>
                            </button>
                        </div>
                    </div>

                    <!--[if BLOCK]><![endif]--><?php if($masterListData): ?>
                        <div class="mb-3">
                            <h5><?php echo e($masterListData['session']->name); ?> - <?php echo e($masterListData['class']->display_name); ?><!--[if BLOCK]><![endif]--><?php if($masterListData['batch']): ?> - <?php echo e($masterListData['batch']->name); ?><?php else: ?><?php endif; ?><!--[if ENDBLOCK]><![endif]--></h5>
                        </div>
                        
                        <!--[if BLOCK]><![endif]--><?php if(empty($masterListData['masterListData']) || count($masterListData['masterListData']) == 0): ?>
                            <div class="card border-warning">
                                <div class="card-body text-center py-5">
                                    <i class="fas fa-users-slash fa-3x text-warning mb-3"></i>
                                    <h5 class="card-title text-warning">No Students Found</h5>
                                    <p class="card-text text-muted">
                                        There are no students in the selected class
                                        <!--[if BLOCK]><![endif]--><?php if($masterListData['batch']): ?>
                                            and batch (<?php echo e($masterListData['batch']->name); ?>)
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        for the <?php echo e($masterListData['session']->name); ?> session.
                                    </p>
                                    <p class="card-text">
                                        <small class="text-muted">
                                            Please check if students are assigned to 
                                            <!--[if BLOCK]><![endif]--><?php if($masterListData['batch']): ?>
                                                this batch or try selecting "All Batches".
                                            <?php else: ?>
                                                this class or try a different class/session.
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </small>
                                    </p>
                                </div>
                            </div>
                        <?php else: ?>

                        <!-- Desktop Table -->
                        <div class="d-none d-lg-block">
                            <div class="text-center mb-4">
                                <img src="<?php echo e(asset('images/rosa-mys-logo.png')); ?>" alt="School Logo" class="mb-3" style="height: 80px;">
                                <h4 class="fw-bold"><?php echo e($masterListData['school_info']['name']); ?> - Termly Master Sheet</h4>
                                <!--[if BLOCK]><![endif]--><?php if($masterListData['school_info']['address']): ?>
                                <p class="mb-1"><?php echo e($masterListData['school_info']['address']); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($masterListData['school_info']['phone_1'] || $masterListData['school_info']['phone_2']): ?>
                                <p class="mb-1">
                                    Phone: <?php echo e($masterListData['school_info']['phone_1']); ?>

                                    <!--[if BLOCK]><![endif]--><?php if($masterListData['school_info']['phone_1'] && $masterListData['school_info']['phone_2']): ?> , <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php echo e($masterListData['school_info']['phone_2']); ?>

                                </p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($masterListData['school_info']['email'] || $masterListData['school_info']['website']): ?>
                                <p class="mb-0">
                                    <!--[if BLOCK]><![endif]--><?php if($masterListData['school_info']['email']): ?>
                                        Email: <?php echo e($masterListData['school_info']['email']); ?>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <!--[if BLOCK]><![endif]--><?php if($masterListData['school_info']['email'] && $masterListData['school_info']['website']): ?> | <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <!--[if BLOCK]><![endif]--><?php if($masterListData['school_info']['website']): ?>
                                        Website: <?php echo e($masterListData['school_info']['website']); ?>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-md-3"><strong>Session:</strong> <?php echo e($masterListData['session']->start_year); ?>/<?php echo e($masterListData['session']->end_year); ?></div>
                                <div class="col-md-3"><strong>Term:</strong> <?php echo e($masterListData['session']->name); ?></div>
                                <div class="col-md-3"><strong>Class:</strong> <?php echo e($masterListData['class']->display_name); ?><!--[if BLOCK]><![endif]--><?php if($masterListData['batch']): ?> - <?php echo e($masterListData['batch']->name); ?><?php endif; ?><!--[if ENDBLOCK]><![endif]--></div>
                                <div class="col-md-3"><strong>Total Possible Score:</strong> <?php echo e(count($masterListData['subjects']) * 100); ?></div>
                            </div>
                            
                            <div class="table-responsive">
                                <table class="table master-list-table table-bordered">
                                    <thead>
                                        <tr>
                                            <th rowspan="2">S/N</th>
                                            <th rowspan="2">Student Name</th>
                                            <th rowspan="2">Student ID</th>
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $masterListData['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th colspan="3" class="subject-header <?php echo e($index > 0 ? 'subject-separator' : ''); ?>"><?php echo e($subject->display_name); ?></th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            <th rowspan="2" class="grand-total">Grand Total</th>
                                            <th rowspan="2">Average</th>
                                            <th rowspan="2" class="grade-cell">A</th>
                                            <th rowspan="2" class="grade-cell">B</th>
                                            <th rowspan="2" class="grade-cell">C</th>
                                            <th rowspan="2" class="grade-cell">D</th>
                                            <th rowspan="2" class="grade-cell">E</th>
                                            <th rowspan="2" class="grade-cell">F</th>
                                            <th rowspan="2" class="position">Position</th>
                                            <th rowspan="2">Remark</th>
                                        </tr>
                                        <tr>
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $masterListData['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th class="subject-subheader <?php echo e($index > 0 ? 'subject-separator' : ''); ?>">CA</th>
                                                <th class="subject-subheader">Exam</th>
                                                <th class="subject-subheader">Total</th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $masterListData['masterListData']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $studentData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($index + 1); ?></td>
                                                <td class="student-name"><?php echo e($studentData['student']->name); ?></td>
                                                <td><?php echo e($studentData['student']->student_id); ?></td>
                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $masterListData['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php $subjectResult = $studentData['subjects'][$subject->id] ?? null; ?>
                                                    <td class="<?php echo e($index > 0 ? 'subject-separator' : ''); ?>"><?php echo e(intval($subjectResult['ca_score'] ?? 0)); ?></td>
                                                    <td><?php echo e(intval($subjectResult['exam_score'] ?? 0)); ?></td>
                                                    <td class="fw-bold"><?php echo e(intval($subjectResult['total'] ?? 0)); ?></td>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                <td class="grand-total"><?php echo e(intval($studentData['grand_total'])); ?></td>
                                                <td><?php echo e($studentData['average']); ?></td>
                                                <td class="grade-cell"><?php echo e($studentData['grades']['A']); ?></td>
                                                <td class="grade-cell"><?php echo e($studentData['grades']['B']); ?></td>
                                                <td class="grade-cell"><?php echo e($studentData['grades']['C']); ?></td>
                                                <td class="grade-cell"><?php echo e($studentData['grades']['D']); ?></td>
                                                <td class="grade-cell"><?php echo e($studentData['grades']['E']); ?></td>
                                                <td class="grade-cell"><?php echo e($studentData['grades']['F']); ?></td>
                                                <td class="position"><?php echo e($studentData['position_suffix']); ?></td>
                                                <td>
                                                    <span class="badge <?php echo e($studentData['remark'] === 'Pass' ? 'bg-success' : 'bg-danger'); ?>">
                                                        <?php echo e($studentData['remark']); ?>

                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="<?php echo e(9 + (count($masterListData['subjects']) * 3)); ?>" class="text-center">
                                                <strong>Class Teacher(s):</strong>
                                                <!--[if BLOCK]><![endif]--><?php if($masterListData['class']->teachers->count() > 0): ?>
                                                    <?php echo e($masterListData['class']->teachers->pluck('name')->join(', ')); ?>

                                                <?php else: ?>
                                                    Not Assigned
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                &nbsp;&nbsp;&nbsp;&nbsp;
                                                <strong>Generated on:</strong> <?php echo e(now()->format('F j, Y \a\t g:i A')); ?>

                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>

                        <!-- Mobile Accordions -->
                        <div class="d-lg-none">
                            <div class="master-list-accordion">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $masterListData['masterListData']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $studentData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="card mb-2">
                                        <div class="card-header p-0">
                                            <div class="p-3" data-bs-toggle="collapse" data-bs-target="#student<?php echo e($index); ?>" style="cursor: pointer;">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <span><?php echo e($studentData['student']->firstname); ?> <?php echo e($studentData['student']->lastname); ?></span>
                                                    <div class="d-flex align-items-center">
                                                        <span class="badge bg-primary me-2"><?php echo e($studentData['position_suffix']); ?></span>
                                                        <span class="badge <?php echo e($studentData['remark'] === 'Pass' ? 'bg-success' : 'bg-danger'); ?> me-2">
                                                            <?php echo e($studentData['remark']); ?>

                                                        </span>
                                                        <i class="fas fa-chevron-down text-muted"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="collapse" id="student<?php echo e($index); ?>">
                                            <div class="card-body">
                                                <div class="student-summary">
                                                    <div class="row">
                                                        <div class="col-6">
                                                            <strong>Grand Total:</strong> <?php echo e($studentData['grand_total']); ?>

                                                        </div>
                                                        <div class="col-6">
                                                            <strong>Average:</strong> <?php echo e($studentData['average']); ?>

                                                        </div>
                                                    </div>
                                                    
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <strong>Grades:</strong>
                                                            <div class="grades-summary mt-2">
                                                                <span class="grade-badge">A: <?php echo e($studentData['grades']['A']); ?></span>
                                                                <span class="grade-badge">B: <?php echo e($studentData['grades']['B']); ?></span>
                                                                <span class="grade-badge">C: <?php echo e($studentData['grades']['C']); ?></span>
                                                                <span class="grade-badge">D: <?php echo e($studentData['grades']['D']); ?></span>
                                                                <span class="grade-badge">E: <?php echo e($studentData['grades']['E']); ?></span>
                                                                <span class="grade-badge">F: <?php echo e($studentData['grades']['F']); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="table-responsive">
                                                    <table class="table table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th>Subject</th>
                                                                <th>CA</th>
                                                                <th>Exam</th>
                                                                <th>Total</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $masterListData['subjects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php $subjectResult = $studentData['subjects'][$subject->id] ?? null; ?>
                                                                <tr>
                                                                    <td><?php echo e($subject->display_name); ?></td>
                                                                    <td><?php echo e($subjectResult['ca_score'] ?? 0); ?></td>
                                                                    <td><?php echo e($subjectResult['exam_score'] ?? 0); ?></td>
                                                                    <td class="fw-bold"><?php echo e($subjectResult['total'] ?? 0); ?></td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        
                            <!-- Print Button -->
                            <div class="text-center mt-4">
                                <button onclick="window.open('<?php echo e($this->getPrintUrl()); ?>', '_blank', 'width=1200,height=800')" 
                                        class="btn btn-primary btn-lg px-4 py-2">
                                    <i class="fas fa-print me-2"></i>Print Master List
                                </button>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="fas fa-chart-line fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Select a session and class to view the master list</p>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\wamp64\www\edu-p\resources\views/livewire/results/master-list.blade.php ENDPATH**/ ?>