<?php $__env->startSection('title', 'Student Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="welcome-card dashboard-welcome mb-4">
                    <h1 class="welcome-title text-light">Welcome Back!</h1>
                    <p class="welcome-subtitle text-light"><?php echo e($student->name); ?></p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('dashboard-announcements', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3007734879-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
        </div>

        <div class="row my-3">
            <div class="col-xl-3 col-md-6 mb-3">
                <div class="dashboard-card">
                    <div class="card-icon classes">
                        <i class="fas fa-school"></i>
                    </div>
                    <div class="card-content">
                        <h3>My Class</h3>
                        <p class="card-number"><?php echo e($student->batch->schoolClass->name ?? 'Not Assigned'); ?></p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-3">
                <div class="dashboard-card">
                    <div class="card-icon pending">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div class="card-content">
                        <h3>Pending Payments</h3>
                        <p class="card-number"><?php echo e($student->paymentRequests()->whereIn('status', ['unpaid', 'processing', 'partial_payment'])->count()); ?></p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-3">
                <div class="dashboard-card">
                    <div class="card-icon payments">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <div class="card-content">
                        <h3>Current Session</h3>
                        <p class="card-number"><?php echo e($currentSession->name ?? 'No Active Session'); ?></p>
                        <?php if($currentSession): ?>
                            <small class="text-muted"><?php echo e($currentSession->start_year); ?>

                                /<?php echo e($currentSession->end_year); ?></small>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-3">
                <div class="dashboard-card">
                    <div class="card-icon student">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="card-content">
                        <h3>Approved Results</h3>
                        <p class="card-number"><?php echo e($student->resultApprovals()->count() + $student->annualResultApprovals()->count()); ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8">
                <!-- Additional content can go here -->
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Quick Actions</h4>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="<?php echo e(route('student.results.termly')); ?>" class="btn btn-primary">
                                <i class="fas fa-chart-line me-2"></i>View Termly Results
                            </a>
                            <a href="<?php echo e(route('student.results.annual')); ?>" class="btn btn-info">
                                <i class="fas fa-calendar-alt me-2"></i>View Annual Results
                            </a>
                            <a href="<?php echo e(route('student.payments.index')); ?>" class="btn btn-warning">
                                <i class="fas fa-money-bill-wave me-2"></i>Payment History
                            </a>
                            <a href="<?php echo e(route('student.profile')); ?>" class="btn btn-secondary">
                                <i class="fas fa-user me-2"></i>My Profile
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.school-portal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\edu-p\resources\views/student/dashboard.blade.php ENDPATH**/ ?>